/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractWtpResourceWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpmodulesWriter
extends AbstractWtpResourceWriter {
    protected static final String FILE_DOT_WTPMODULES = ".wtpmodules";

    public EclipseWtpmodulesWriter(Log log, File eclipseProjectDir, MavenProject project, Collection artifacts) {
        super(log, eclipseProjectDir, project, artifacts);
    }

    public void write(List referencedReactorArtifacts, EclipseSourceDir[] sourceDirs, ArtifactRepository localRepository, File buildOutputDirectory) throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(this.getEclipseProjectDirectory(), FILE_DOT_WTPMODULES));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement("project-modules");
        writer.addAttribute("id", "moduleCoreId");
        writer.startElement("wb-module");
        writer.addAttribute("deploy-name", this.getProject().getArtifactId());
        String packaging = this.getProject().getPackaging();
        writer.startElement("module-type");
        this.writeModuleTypeAccordingToPackaging(this.getProject(), (XMLWriter)writer, packaging, buildOutputDirectory);
        writer.endElement();
        String target = "/";
        if ("war".equals(this.getProject().getPackaging())) {
            String warSourceDirectory = EclipseUtils.getPluginSetting(this.getProject(), "maven-war-plugin", "warSourceDirectory", "/src/main/webapp");
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", "/" + EclipseUtils.toRelativeAndFixSeparator(this.getEclipseProjectDirectory(), new File(this.getEclipseProjectDirectory(), warSourceDirectory), false));
            writer.endElement();
            this.writeWarOrEarResources((XMLWriter)writer, this.getProject(), referencedReactorArtifacts, localRepository);
            target = "/WEB-INF/classes";
        } else if ("ear".equals(this.getProject().getPackaging())) {
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", "/");
            writer.addAttribute("source-path", "/");
            writer.endElement();
            this.writeWarOrEarResources((XMLWriter)writer, this.getProject(), referencedReactorArtifacts, localRepository);
        }
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            if (dir.isTest()) continue;
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", target);
            writer.addAttribute("source-path", dir.getPath());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        IOUtil.close((Writer)w);
    }
}

