/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseCleanMojo;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class RadCleanMojo
extends EclipseCleanMojo {
    private MavenProject project;

    protected void cleanExtras() throws MojoExecutionException {
        this.delete(new File(this.getBasedir(), ".j2ee"));
        this.delete(new File(this.getBasedir(), ".websettings"));
        this.delete(new File(this.getBasedir(), ".website-config"));
        this.handleLibs();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    private void handleEarLibs() throws MojoExecutionException {
        File targetDir = this.project.getBasedir();
        this.deleteJarArtifactsInDirectory(targetDir);
        this.deleteWarArtifactsInDirectory(targetDir);
    }

    private void handleLibs() throws MojoExecutionException {
        if ("ear".equals(this.getPackaging())) {
            this.handleEarLibs();
        } else if ("war".equals(this.getPackaging())) {
            this.handleWarLibs();
        }
    }

    private void handleWarLibs() throws MojoExecutionException {
        File basedir = this.project.getBasedir();
        File warSourceDirectory = new File(IdeUtils.getPluginSetting(this.project, "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", "src/main/webapp"));
        String webContentDir = IdeUtils.toRelativeAndFixSeparator(basedir, warSourceDirectory, false);
        String srcMainWebappWebInfLibDirname = basedir.getAbsolutePath() + File.separatorChar + webContentDir + File.separatorChar + "WEB-INF" + File.separatorChar + "lib";
        File srcMainWebappWebInfLibDir = new File(srcMainWebappWebInfLibDirname);
        srcMainWebappWebInfLibDir.mkdirs();
        this.deleteJarArtifactsInDirectory(srcMainWebappWebInfLibDir);
    }

    protected void deleteJarArtifactsInDirectory(File directory) throws MojoExecutionException {
        this.deleteArtifactsInDirectory(directory, "jar");
    }

    protected void deleteWarArtifactsInDirectory(File directory) throws MojoExecutionException {
        this.deleteArtifactsInDirectory(directory, "war");
    }

    private void deleteArtifactsInDirectory(File directory, String packagingType) throws MojoExecutionException {
        if ("jar".equalsIgnoreCase(packagingType) || "war".equalsIgnoreCase(packagingType)) {
            String[] oldFiles;
            for (String oldFile : oldFiles = FileUtils.getFilesFromExtension((String)directory.getAbsolutePath(), (String[])new String[]{packagingType})) {
                File f = new File(oldFile);
                this.delete(f);
            }
        }
    }
}

