/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractIdeSupportMojo
extends AbstractMojo
implements LogEnabled {
    protected MavenProject project;
    protected MavenProject executedProject;
    protected String packaging;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactCollector artifactCollector;
    protected ArtifactMetadataSource artifactMetadataSource;
    private RuntimeInformation runtimeInformation;
    protected List remoteArtifactRepositories;
    protected ArtifactRepository localRepository;
    protected List reactorProjects;
    private boolean skip;
    protected boolean downloadSources;
    protected boolean downloadJavadocs;
    protected boolean forceRecheck;
    protected Logger logger;
    private List missingSourceDependencies = new ArrayList();
    private List missingJavadocDependencies = new ArrayList();
    private IdeDependency[] ideDeps;
    private boolean resolveDependencies = true;

    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource artifactMetadataSource) {
        this.artifactMetadataSource = artifactMetadataSource;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List getReactorProjects() {
        return this.reactorProjects;
    }

    public void setReactorProjects(List reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    public List getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    public void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public MavenProject getExecutedProject() {
        return this.executedProject;
    }

    public void setExecutedProject(MavenProject executedProject) {
        this.executedProject = executedProject;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public boolean getDownloadJavadocs() {
        return this.downloadJavadocs;
    }

    public void setDownloadJavadocs(boolean downloadJavadoc) {
        this.downloadJavadocs = downloadJavadoc;
    }

    public boolean getDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    protected void setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
    }

    protected boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    protected abstract boolean getUseProjectReferences();

    protected abstract boolean setup() throws MojoExecutionException;

    protected abstract void writeConfiguration(IdeDependency[] var1) throws MojoExecutionException;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        boolean processProject = this.setup();
        if (!processProject) {
            return;
        }
        IdeDependency[] deps = this.doDependencyResolution();
        this.resolveSourceAndJavadocArtifacts(deps);
        this.writeConfiguration(deps);
        this.reportMissingArtifacts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IdeDependency[] doDependencyResolution() throws MojoExecutionException {
        if (this.ideDeps == null) {
            if (this.resolveDependencies) {
                MavenProject project = this.getProject();
                ArtifactRepository localRepo = this.getLocalRepository();
                List deps = this.getProject().getDependencies();
                ArrayList<IdeDependency> dependencies = new ArrayList<IdeDependency>();
                if (deps != null) {
                    ArtifactResolutionResult artifactResolutionResult;
                    Map managedVersions = this.createManagedVersionMap(this.getArtifactFactory(), project.getId(), project.getDependencyManagement());
                    try {
                        ArrayList<Object> listeners = new ArrayList<Object>();
                        if (this.logger.isDebugEnabled()) {
                            listeners.add(new DebugResolutionListener(this.logger));
                        }
                        listeners.add(new WarningResolutionListener(this.logger));
                        artifactResolutionResult = this.artifactCollector.collect(this.getProjectArtifacts(), project.getArtifact(), managedVersions, localRepo, project.getRemoteArtifactRepositories(), this.getArtifactMetadataSource(), null, listeners);
                    }
                    catch (ArtifactResolutionException e) {
                        this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                        this.getLog().error((CharSequence)Messages.getString("AbstractIdeSupportMojo.artifactresolution", new Object[]{e.getGroupId(), e.getArtifactId(), e.getVersion(), e.getMessage()}));
                        return new IdeDependency[0];
                    }
                    HashSet<String> emittedReactorProjectId = new HashSet<String>();
                    for (Object o : artifactResolutionResult.getArtifactResolutionNodes()) {
                        boolean isOsgiBundle;
                        ResolutionNode node = (ResolutionNode)o;
                        int dependencyDepth = node.getDepth();
                        Artifact art = node.getArtifact();
                        if (this.hasToResolveJar(art)) {
                            try {
                                this.artifactResolver.resolve(art, node.getRemoteRepositories(), this.localRepository);
                            }
                            catch (ArtifactNotFoundException e) {
                                this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                                this.getLog().warn((CharSequence)Messages.getString("AbstractIdeSupportMojo.artifactdownload", new Object[]{e.getGroupId(), e.getArtifactId(), e.getVersion(), e.getMessage()}));
                            }
                            catch (ArtifactResolutionException e) {
                                this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
                                this.getLog().warn((CharSequence)Messages.getString("AbstractIdeSupportMojo.artifactresolution", new Object[]{e.getGroupId(), e.getArtifactId(), e.getVersion(), e.getMessage()}));
                            }
                        }
                        boolean includeArtifact = true;
                        if (this.getExcludes() != null) {
                            String artifactFullId = art.getGroupId() + ":" + art.getArtifactId();
                            if (this.getExcludes().contains(artifactFullId)) {
                                this.getLog().info((CharSequence)("excluded: " + artifactFullId));
                                includeArtifact = false;
                            }
                        }
                        if (!includeArtifact || this.getUseProjectReferences() && this.isAvailableAsAReactorProject(art) && !emittedReactorProjectId.add(art.getGroupId() + '-' + art.getArtifactId())) continue;
                        String osgiSymbolicName = null;
                        if (art.getFile() != null) {
                            ZipFile jarFile = null;
                            try {
                                jarFile = new JarFile(art.getFile(), false, 1);
                                Manifest manifest = ((JarFile)jarFile).getManifest();
                                if (manifest != null) {
                                    osgiSymbolicName = manifest.getMainAttributes().getValue(new Attributes.Name("Bundle-SymbolicName"));
                                }
                            }
                            catch (IOException e) {
                                this.getLog().info((CharSequence)("Unable to read jar manifest from " + art.getFile()));
                            }
                            finally {
                                if (jarFile != null) {
                                    try {
                                        jarFile.close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                        }
                        boolean bl = isOsgiBundle = osgiSymbolicName != null;
                        IdeDependency dep = new IdeDependency(art.getGroupId(), art.getArtifactId(), art.getVersion(), art.getClassifier(), this.useProjectReference(art), "test".equals(art.getScope()), "system".equals(art.getScope()), "provided".equals(art.getScope()), art.getArtifactHandler().isAddedToClasspath(), art.getFile(), art.getType(), isOsgiBundle, osgiSymbolicName, dependencyDepth, this.getProjectNameForArifact(art));
                        if (dependencies.contains(dep)) continue;
                        dependencies.add(dep);
                    }
                }
                this.ideDeps = dependencies.toArray(new IdeDependency[dependencies.size()]);
            } else {
                this.ideDeps = new IdeDependency[0];
            }
        }
        return this.ideDeps;
    }

    public abstract String getProjectNameForArifact(Artifact var1);

    private Set getProjectArtifacts() throws MojoExecutionException {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (Object o : this.getProject().getDependencies()) {
            VersionRange versionRange;
            Dependency dependency = (Dependency)o;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException(Messages.getString("AbstractIdeSupportMojo.unabletoparseversion", new Object[]{dependency.getArtifactId(), dependency.getVersion(), dependency.getManagementKey(), e.getMessage()}), (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact art = this.getArtifactFactory().createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            this.handleExclusions(art, dependency);
            artifacts.add(art);
        }
        return artifacts;
    }

    private void handleExclusions(Artifact artifact, Dependency dependency) {
        ArrayList<String> exclusions = new ArrayList<String>();
        for (Exclusion e : dependency.getExclusions()) {
            exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
        }
        ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
        artifact.setDependencyFilter((ArtifactFilter)newFilter);
    }

    protected boolean isAvailableAsAReactorProject(Artifact artifact) {
        return this.getReactorProject(artifact) != null;
    }

    protected MavenProject getReactorProject(Artifact artifact) {
        if (this.reactorProjects != null) {
            for (Object reactorProject1 : this.reactorProjects) {
                MavenProject reactorProject = (MavenProject)reactorProject1;
                if (!reactorProject.getGroupId().equals(artifact.getGroupId()) || !reactorProject.getArtifactId().equals(artifact.getArtifactId())) continue;
                if (reactorProject.getVersion().equals(artifact.getVersion())) {
                    return reactorProject;
                }
                this.getLog().info((CharSequence)("Artifact " + artifact.getId() + " already available as a reactor project, but with different version. Expected: " + artifact.getVersion() + ", found: " + reactorProject.getVersion()));
            }
        }
        return null;
    }

    protected IdeDependency[] getWorkspaceArtefacts() {
        return new IdeDependency[0];
    }

    private Map createManagedVersionMap(ArtifactFactory artifactFactory, String projectId, DependencyManagement dependencyManagement) throws MojoExecutionException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                    this.handleExclusions(artifact, d);
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new MojoExecutionException(Messages.getString("AbstractIdeSupportMojo.unabletoparseversion", new Object[]{projectId, d.getVersion(), d.getManagementKey(), e.getMessage()}), (Exception)((Object)e));
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    private void resolveSourceAndJavadocArtifacts(IdeDependency[] deps) {
        List missingSources = this.resolveDependenciesWithClassifier(deps, "sources", this.getDownloadSources());
        this.missingSourceDependencies.addAll(missingSources);
        List missingJavadocs = this.resolveDependenciesWithClassifier(deps, "javadoc", this.getDownloadJavadocs());
        this.missingJavadocDependencies.addAll(missingJavadocs);
    }

    private List resolveDependenciesWithClassifier(IdeDependency[] deps, String inClassifier, boolean includeRemoteRepositories) {
        ArrayList<IdeDependency> missingClassifierDependencies = new ArrayList<IdeDependency>();
        List remoteRepos = includeRemoteRepositories ? this.getRemoteArtifactRepositories() : Collections.EMPTY_LIST;
        for (IdeDependency dependency : deps) {
            if (dependency.isReferencedProject() || dependency.isSystemScoped()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Searching for sources for " + dependency.getId() + ":" + dependency.getClassifier() + " at " + dependency.getId() + ":" + inClassifier));
            }
            Artifact baseArtifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
            if (!(baseArtifact = IdeUtils.resolveArtifact(this.artifactResolver, baseArtifact, remoteRepos, this.localRepository, this.getLog())).isResolved()) continue;
            Artifact artifact = IdeUtils.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), inClassifier, this.artifactFactory);
            File notAvailableMarkerFile = IdeUtils.getNotAvailableMarkerFile(this.localRepository, artifact);
            if (this.forceRecheck && notAvailableMarkerFile.exists() && !notAvailableMarkerFile.delete()) {
                this.getLog().warn((CharSequence)Messages.getString("AbstractIdeSupportMojo.unabletodeletenotavailablemarkerfile", notAvailableMarkerFile));
            }
            if (notAvailableMarkerFile.exists()) continue;
            if ((artifact = IdeUtils.resolveArtifact(this.artifactResolver, artifact, remoteRepos, this.localRepository, this.getLog())).isResolved()) {
                if ("sources".equals(inClassifier)) {
                    dependency.setSourceAttachment(artifact.getFile());
                    continue;
                }
                if (!"javadoc".equals(inClassifier)) continue;
                dependency.setJavadocAttachment(artifact.getFile());
                continue;
            }
            if (includeRemoteRepositories) {
                try {
                    notAvailableMarkerFile.createNewFile();
                    this.getLog().debug((CharSequence)Messages.getString("AbstractIdeSupportMojo.creatednotavailablemarkerfile", notAvailableMarkerFile));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)Messages.getString("AbstractIdeSupportMojo.failedtocreatenotavailablemarkerfile", notAvailableMarkerFile));
                }
            }
            missingClassifierDependencies.add(dependency);
        }
        return missingClassifierDependencies;
    }

    private void reportMissingArtifacts() {
        IdeDependency art;
        StringBuilder msg = new StringBuilder();
        if (this.getDownloadSources() && !this.missingSourceDependencies.isEmpty()) {
            msg.append(Messages.getString("AbstractIdeSupportMojo.sourcesnotavailable"));
            for (Object missingSourceDependency : this.missingSourceDependencies) {
                art = (IdeDependency)missingSourceDependency;
                msg.append(Messages.getString("AbstractIdeSupportMojo.sourcesmissingitem", art.getId()));
            }
            msg.append("\n");
        }
        if (this.getDownloadJavadocs() && !this.missingJavadocDependencies.isEmpty()) {
            msg.append(Messages.getString("AbstractIdeSupportMojo.javadocnotavailable"));
            for (Object missingJavadocDependency : this.missingJavadocDependencies) {
                art = (IdeDependency)missingJavadocDependency;
                msg.append(Messages.getString("AbstractIdeSupportMojo.javadocmissingitem", art.getId()));
            }
            msg.append("\n");
        }
        this.getLog().info((CharSequence)msg);
    }

    public abstract List getExcludes();

    protected boolean hasToResolveJar(Artifact art) {
        return !this.getUseProjectReferences() || !this.isAvailableAsAReactorProject(art);
    }

    protected boolean useProjectReference(Artifact art) {
        return this.getUseProjectReferences() && this.isAvailableAsAReactorProject(art);
    }

    protected boolean isMavenVersion(String version) {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)version);
            ArtifactVersion mavenVersion = this.runtimeInformation.getApplicationVersion();
            return versionRange.containsVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

