/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoFileUtils
extends FileUtils {
    public static int NumofDir = 0;

    public static int copyDirectoryStructure(File sourceDirectory, File destinationDirectory, HashSet<Pattern> ignoreFiles) throws IOException {
        return ExoFileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, ignoreFiles, false);
    }

    public static int copyDirectoryStructure(File sourceDirectory, File destinationDirectory, HashSet<Pattern> ignoreFiles, boolean overwrite) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        int counter = 0;
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                if (ExoFileUtils.isIgnoredFile(ignoreFiles, file.getName())) continue;
                File fileInDst = new File(destination.getPath());
                if (fileInDst.exists()) {
                    if (!overwrite && file.lastModified() <= fileInDst.lastModified()) continue;
                    destination = destination.getParentFile();
                    ExoFileUtils.copyFileToDirectory((File)file, (File)destination);
                    ++counter;
                    continue;
                }
                destination = destination.getParentFile();
                ExoFileUtils.copyFileToDirectory((File)file, (File)destination);
                ++counter;
                continue;
            }
            if (file.isDirectory()) {
                if (ExoFileUtils.isIgnoredFile(ignoreFiles, file.getName())) continue;
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                counter += ExoFileUtils.copyDirectoryStructure(file, destination, ignoreFiles, overwrite);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
        return counter;
    }

    public static boolean isIgnoredFile(HashSet<Pattern> set, String input) {
        for (Pattern p : set) {
            Matcher m = p.matcher(input);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean containFile(File parentDir, String childName) {
        String[] childFiles = parentDir.list();
        for (int i = 0; i < childFiles.length; ++i) {
            if (!childFiles[i].equals(childName)) continue;
            return true;
        }
        return false;
    }

    public static void deleteContentInDirectory(File dir) throws Exception {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                files[i].delete();
                continue;
            }
            if (!files[i].isDirectory()) continue;
            ExoFileUtils.deleteDirectory((File)files[i]);
        }
    }

    public static void addToArchive(File input, File output) throws Exception {
        HashSet<Pattern> ignoredFiles = new HashSet<Pattern>();
        ExoFileUtils.addToArchive(input, output, ignoredFiles);
    }

    public static void extractZip(String zipFile, String destDir) throws Exception {
        JarFile zip = new JarFile(zipFile);
        Enumeration<? extends ZipEntry> entries = ((ZipFile)zip).entries();
        while (entries.hasMoreElements()) {
            int count;
            ZipEntry entry = entries.nextElement();
            File dest = new File(destDir + File.separator + entry.getName());
            if (entry.isDirectory()) {
                dest.mkdirs();
                continue;
            }
            File parent = dest.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            InputStream is = ((ZipFile)zip).getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(dest);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[4096];
            while ((count = is.read(buffer)) >= 0) {
                bos.write(buffer, 0, count);
            }
            bos.close();
            is.close();
        }
        zip.close();
    }

    public static void addToArchive(File input, File output, HashSet<Pattern> ignoredFiles) throws Exception {
        String path = input.getAbsolutePath();
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        BufferedInputStream origin = null;
        NumofDir = 0;
        System.out.print("[");
        List<File> files = ExoFileUtils.getFiles(input, ignoredFiles);
        int NumofFile = 0;
        for (File f : files) {
            String filePath = f.getAbsolutePath();
            if (filePath.startsWith(path)) {
                filePath = filePath.substring(path.length() - input.getName().length());
            }
            filePath = filePath.replace("\\", "/");
            if (!f.isDirectory()) {
                FileInputStream fi = new FileInputStream(f);
                origin = new BufferedInputStream(fi, 2048);
            } else {
                filePath = filePath + "/";
            }
            ZipEntry entry = new ZipEntry(filePath);
            out.putNextEntry(entry);
            if (f.isFile()) {
                int count;
                ++NumofFile;
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.closeEntry();
        }
        out.close();
        System.out.println("=>]");
        System.out.println("zipped " + NumofDir + " directories include " + NumofFile + " files");
    }

    private static List<File> getFiles(File dir, final HashSet<Pattern> ignoredFiles) {
        final LinkedList<File> files = new LinkedList<File>();
        dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                files.add(f);
                return true;
            }
        });
        dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isFile()) {
                    return false;
                }
                if (f.isDirectory() && !ExoFileUtils.isIgnoredFile(ignoredFiles, f.getName())) {
                    files.addAll(ExoFileUtils.getFiles(f, ignoredFiles));
                    ++NumofDir;
                    System.out.print("=");
                }
                return false;
            }
        });
        if (files.size() == 0) {
            files.add(dir);
        }
        return files;
    }
}

