/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exo;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.exoplatform.maven.plugin.exo.ExoFileUtils;
import org.exoplatform.maven.plugin.exo.PackagingCommand;
import org.exoplatform.maven.plugin.exo.PackagingConfiguration;

public class ExoPackaging
extends AbstractMojo {
    protected MavenProject project;
    private List<PackagingConfiguration> packagingConfigs;

    public void execute() throws MojoExecutionException {
        PackagingConfiguration packagingConfig = null;
        for (PackagingConfiguration config : this.packagingConfigs) {
            if (!config.getType().equals(this.project.getPackaging())) continue;
            packagingConfig = config;
            break;
        }
        this.setDefaultPConfig(packagingConfig);
        List<String> scripts = packagingConfig.getScripts();
        try {
            for (String command : scripts) {
                if (command.endsWith(".class")) {
                    String className = command.substring(0, command.indexOf(".class"));
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    PackagingCommand commandObject = (PackagingCommand)cl.loadClass(className).newInstance();
                    commandObject.execute(packagingConfig);
                    continue;
                }
                Binding binding = new Binding();
                binding.setVariable("packagingConfig", (Object)packagingConfig);
                binding.setVariable("FileUtil", ExoFileUtils.class);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate(command);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("FALSE", ex);
        }
    }

    private void setDefaultPConfig(PackagingConfiguration packagingConfig) {
        String outputDirectory = packagingConfig.getOutputDirectory();
        String outputFileName = packagingConfig.getOutputFileName();
        if (packagingConfig.getMavenProject() == null) {
            packagingConfig.setMavenProject(this.project);
        }
        if (outputDirectory == null || outputDirectory.equalsIgnoreCase("")) {
            packagingConfig.setOutputDirectory(packagingConfig.getMavenProject().getBuild().getDirectory());
        }
        if (outputFileName == null || outputFileName.equalsIgnoreCase("")) {
            packagingConfig.setOutputFileName(packagingConfig.getMavenProject().getBuild().getFinalName());
        }
        if (packagingConfig.getScripts().isEmpty()) {
            throw new RuntimeException("You need to define the chained commands");
        }
    }
}

