/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven.plugin.exo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.exoplatform.maven.plugin.exo.DeployConfiguration;
import org.exoplatform.maven.plugin.exo.ExoFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtils
extends FileUtils {
    public static void deployProject(File dirJar, File dirWar, MavenProject project) throws Exception {
        DeployConfiguration deployConfig = new DeployConfiguration();
        deployConfig.setDeployLibDir(dirJar.getPath());
        deployConfig.setDeployWebappDir(dirWar.getPath());
        deployConfig.setMavenProject(project);
        ProjectUtils.deployProject(deployConfig);
    }

    public static void deployProject(DeployConfiguration deployConfig) throws Exception {
        MavenProject project = deployConfig.getMavenProject();
        String deployLibDir = deployConfig.getDeployLibDir();
        String deployWebappDir = deployConfig.getDeployWebappDir();
        File directoryJar = new File(deployLibDir);
        File directoryWar = new File(deployWebappDir);
        if (!directoryJar.getParentFile().exists()) {
            System.out.println("The directory " + directoryJar.getPath() + " does not exists !");
            return;
        }
        if (directoryJar.getParentFile().exists()) {
            directoryJar.mkdirs();
        }
        if (!directoryWar.getParentFile().exists()) {
            System.out.println("The directory " + directoryWar.getPath() + " does not exists !");
            return;
        }
        if (directoryWar.getParentFile().exists()) {
            directoryWar.mkdirs();
        }
        int counter = 0;
        ProjectUtils.deleteFileOnExist(directoryWar, project.getBuild().getFinalName());
        if (project.getPackaging().equals("jar")) {
            ++counter;
            File moduleFile = new File(project.getBasedir().toString() + "/target/" + project.getArtifactId() + "-" + project.getVersion() + "." + project.getPackaging());
            ProjectUtils.copyFileToDirectory((File)moduleFile, (File)directoryJar);
            ProjectUtils.printMessage("deploy", "  Deployed file '" + project.getArtifactId() + "' to " + directoryJar.getPath());
        } else if (project.getPackaging().equals("exo-war") || project.getPackaging().equals("exo-jcr") || project.getPackaging().equals("exo-portal") || project.getPackaging().equals("exo-portlet")) {
            File deployWar = new File(project.getBasedir().toString() + "/target/" + project.getBuild().getFinalName() + ".war");
            ProjectUtils.copyFileToDirectory((File)deployWar, (File)directoryWar);
            ProjectUtils.printMessage("deploy", "  Deployed file '" + project.getArtifactId() + "' to " + directoryWar.getPath());
            ++counter;
        }
        if (counter > 0) {
            ProjectUtils.printMessage("deploy", "  DEPLOY : " + counter + " project");
        }
    }

    public static void deployProject(File dirJar, File dirWar, MavenProject project, String scope, HashSet<String> ignoreProjects) throws Exception {
        DeployConfiguration deployConfig = new DeployConfiguration();
        deployConfig.setDeployLibDir(dirJar.getPath());
        deployConfig.setDeployWebappDir(dirWar.getPath());
        deployConfig.setMavenProject(project);
        ProjectUtils.deployProject(deployConfig);
        ProjectUtils.deployDependencies(deployConfig, scope, ignoreProjects);
    }

    public static void deployDependencies(DeployConfiguration deployConfig, String scope, HashSet<String> ignoreProjects) throws IOException {
        int counter = 0;
        MavenProject project = deployConfig.getMavenProject();
        String deployLibDir = deployConfig.getDeployLibDir();
        String deployWebappDir = deployConfig.getDeployWebappDir();
        File directoryJar = new File(deployLibDir);
        File directoryWar = new File(deployWebappDir);
        Set artifacts = project.getArtifacts();
        ArrayList list = new ArrayList();
        list.addAll(artifacts);
        Collections.sort(list);
        for (Artifact da : list) {
            String finalName;
            if (da.getScope().equalsIgnoreCase("test") || ignoreProjects.contains(da.getArtifactId())) continue;
            String projectType = da.getType();
            if (!scope.equalsIgnoreCase("all") && (scope.equalsIgnoreCase("all") || !da.getScope().equalsIgnoreCase(scope))) continue;
            if ("jar".equals(projectType)) {
                ProjectUtils.copyFileToDirectory((File)da.getFile(), (File)directoryJar);
                ProjectUtils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + directoryJar.getPath());
                ++counter;
                continue;
            }
            if ("ejb".equals(projectType)) {
                finalName = ProjectUtils.getFinalName(da.getArtifactId(), ".jar");
                ProjectUtils.copyFile((File)da.getFile(), (File)new File(deployConfig.getDeployEjbDir() + '/' + finalName));
                ProjectUtils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + deployConfig.getDeployEjbDir());
                ++counter;
                continue;
            }
            if ("rar".equals(projectType)) {
                finalName = ProjectUtils.getFinalName(da.getArtifactId(), ".rar");
                if (deployConfig.getServerType() != null && deployConfig.getServerType().indexOf("tomcat") >= 0) {
                    ProjectUtils.printMessage("info", "  Deploy of projects of '" + projectType + "' type on a server type '" + deployConfig.getServerType() + "' is not provided. Dependency name '" + finalName + "'");
                    continue;
                }
                ProjectUtils.copyFile((File)da.getFile(), (File)new File(deployConfig.getDeployRarDir() + '/' + finalName));
                ProjectUtils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + deployConfig.getDeployRarDir());
                ++counter;
                continue;
            }
            if (!projectType.equals("exo-war") && !projectType.equals("exo-portal") && !projectType.equals("exo-portlet") && directoryWar == null) continue;
            finalName = ProjectUtils.getFinalName(da.getArtifactId(), ".war");
            ProjectUtils.deleteFileOnExist(directoryWar, finalName.substring(0, finalName.lastIndexOf(".")));
            ProjectUtils.copyFileToDirectory((File)da.getFile(), (File)directoryWar);
            ++counter;
            File[] fileChild = directoryWar.listFiles();
            for (int j = 0; j < fileChild.length; ++j) {
                if (!fileChild[j].getName().equals(da.getFile().getName())) continue;
                File reFile = new File(fileChild[j].getParent() + "/" + finalName);
                ProjectUtils.rename((File)fileChild[j], (File)reFile);
                ProjectUtils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + directoryWar.getPath());
            }
        }
        if (counter > 0) {
            ProjectUtils.printMessage("deploy", "  DEPLOY : " + counter + " dependencies");
        }
    }

    public static int deployResourceFiles(File srcDir, File desDir, HashSet<Pattern> ignoreFiles, HashSet<String> copyFiles) throws IOException {
        if (!srcDir.exists()) {
            throw new IOException("Source directory doesn't exists (" + srcDir.getAbsolutePath() + ").");
        }
        int counter = 0;
        File[] files = srcDir.listFiles();
        String sourcePath = srcDir.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(desDir, dest);
            if (file.isFile()) {
                if (!copyFiles.contains(file.getName().substring(file.getName().lastIndexOf("."))) || ExoFileUtils.isIgnoredFile(ignoreFiles, file.getName())) continue;
                if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                if (file.lastModified() <= destination.lastModified()) continue;
                destination = destination.getParentFile();
                ExoFileUtils.copyFileToDirectory((File)file, (File)destination);
                ++counter;
                continue;
            }
            if (!file.isDirectory() || ExoFileUtils.isIgnoredFile(ignoreFiles, file.getName())) continue;
            counter += ProjectUtils.deployResourceFiles(file, destination, ignoreFiles, copyFiles);
        }
        return counter;
    }

    private static void deleteFileOnExist(File parentDir, String childName) throws IOException {
        File fileOld;
        if (ExoFileUtils.containFile(parentDir, childName)) {
            fileOld = new File(parentDir.getPath() + "/" + childName);
            ProjectUtils.printMessage("delete", "  Deleted file " + fileOld);
            ProjectUtils.forceDelete((File)fileOld);
        }
        if (ExoFileUtils.containFile(parentDir, childName + ".war")) {
            fileOld = new File(parentDir.getPath() + "/" + childName + ".war");
            ProjectUtils.printMessage("delete", "  Deleted file " + fileOld);
            ProjectUtils.forceDelete((File)fileOld);
        }
    }

    public static HashSet<String> velocityFiles() {
        HashSet<String> velocity = new HashSet<String>();
        velocity.add(".vm");
        return velocity;
    }

    public static HashSet<String> groovyFiles() {
        HashSet<String> groovy = new HashSet<String>();
        groovy.add(".groovy");
        groovy.add(".gtmpl");
        return groovy;
    }

    public static String getFinalName(String name, String extension) {
        int in = name.lastIndexOf(".");
        name = in >= 0 ? name.substring(in + 1) + extension : name + extension;
        return name;
    }

    public static void printMessage(String category, String message) {
        System.out.println("  [" + category + "]  " + message);
    }
}

