/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils
extends FileUtils {
    public static void deployProject(File dirJar, File dirWar, MavenProject project, boolean deployDep, HashSet<String> ignoreProjects) throws Exception {
        if (!dirJar.exists()) {
            System.out.println("The directory " + dirJar.getParent() + " does not exists !");
            return;
        }
        if (!dirWar.exists()) {
            System.out.println("The directory " + dirWar.getParent() + " does not exists !");
            return;
        }
        int counter = 0;
        if (deployDep) {
            counter += Utils.deployedDependency(dirJar, dirWar, project, ignoreProjects).size();
        }
        Utils.deleteFileOnExist(dirWar, project.getBuild().getFinalName());
        if (project.getPackaging().equals("jar")) {
            ++counter;
            File moduleFile = new File(project.getBasedir().toString() + "/target/" + project.getArtifactId() + "-" + project.getVersion() + "." + project.getPackaging());
            Utils.copyFileToDirectory((File)moduleFile, (File)dirJar);
            Utils.printMessage("deploy", "  Deployed file '" + project.getArtifactId() + "' to " + dirJar.getPath());
        } else if (project.getPackaging().equals("war") || project.getPackaging().equals("exo-jcr") || project.getPackaging().equals("exo-portal") || project.getPackaging().equals("exo-portlet")) {
            File deployWar = new File(project.getBasedir().toString() + "/target/" + project.getBuild().getFinalName() + ".war");
            Utils.copyFileToDirectory((File)deployWar, (File)dirWar);
            Utils.printMessage("deploy", "  Deployed file '" + project.getArtifactId() + "' to " + dirWar.getPath());
            ++counter;
        }
        Utils.printMessage("deploy", "  TOTAL DEPLOY : " + counter + " project");
    }

    public static HashSet<Artifact> deployedDependency(File dirJar, File dirWar, MavenProject project, HashSet<String> ignoreProjects) throws IOException {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        Set artifacts = project.getArtifacts();
        ArrayList list = new ArrayList();
        list.addAll(artifacts);
        Collections.sort(list);
        for (Artifact da : list) {
            if (da.getScope().equalsIgnoreCase("test") || ignoreProjects.contains(da.getArtifactId())) continue;
            String projectType = da.getType();
            if ("jar".equals(projectType)) {
                Utils.copyFileToDirectory((File)da.getFile(), (File)dirJar);
                Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dirJar.getPath());
                dependencies.add(da);
                continue;
            }
            if (!projectType.equals("war") && !projectType.equals("exo-portal") && !projectType.equals("exo-portlet") && dirWar == null) continue;
            String finalName = Utils.getFinalName(da.getArtifactId());
            Utils.deleteFileOnExist(dirWar, finalName.substring(0, finalName.lastIndexOf(".")));
            Utils.copyFileToDirectory((File)da.getFile(), (File)dirWar);
            dependencies.add(da);
            File[] fileChild = dirWar.listFiles();
            for (int j = 0; j < fileChild.length; ++j) {
                if (!fileChild[j].getName().equals(da.getFile().getName())) continue;
                File reFile = new File(fileChild[j].getParent() + "/" + finalName);
                Utils.rename((File)fileChild[j], (File)reFile);
                Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dirWar.getPath());
            }
        }
        return dependencies;
    }

    public static HashSet<Artifact> deployedDependency2(File dirJar, File dirWar, File dirRar, MavenProject project, HashSet<String> ignoreProjects) throws IOException {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        Set artifacts = project.getArtifacts();
        ArrayList list = new ArrayList();
        list.addAll(artifacts);
        Collections.sort(list);
        for (Artifact da : list) {
            if (da.getScope().equalsIgnoreCase("test") || ignoreProjects.contains(da.getArtifactId())) continue;
            String projectType = da.getType();
            if (projectType.equals("jar") && dirJar != null) {
                Utils.copyFileToDirectory((File)da.getFile(), (File)dirJar);
                Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dirJar.getPath());
                dependencies.add(da);
                continue;
            }
            if (projectType.equals("rar") && dirRar != null) {
                Utils.copyFileToDirectory((File)da.getFile(), (File)dirRar);
                Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dirRar.getPath());
                dependencies.add(da);
                continue;
            }
            if (!projectType.equals("war") && !projectType.equals("exo-pc") || dirWar == null) continue;
            String finalName = Utils.getFinalName(da.getArtifactId());
            File finalname = new File(dirWar + "/" + finalName);
            Utils.deleteFileOnExist(dirWar, finalName.substring(0, finalName.lastIndexOf(".")));
            Utils.copyFile((File)da.getFile(), (File)finalname);
            dependencies.add(da);
            File[] fileChild = dirWar.listFiles();
            for (int j = 0; j < fileChild.length; ++j) {
                if (!fileChild[j].getName().equals(da.getFile().getName())) continue;
                File reFile = new File(fileChild[j].getParent() + "/" + finalName);
                Utils.rename((File)fileChild[j], (File)reFile);
                Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dirWar.getPath());
            }
        }
        return dependencies;
    }

    public static HashSet<Artifact> deployedDependency3(File dirJar, MavenProject project, HashSet<String> onlyToInclude) throws IOException {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        Set artifacts = project.getArtifacts();
        ArrayList list = new ArrayList();
        list.addAll(artifacts);
        Collections.sort(list);
        for (Artifact da : list) {
            String projectType;
            if (!onlyToInclude.contains(da.getArtifactId()) || !(projectType = da.getType()).equals("jar") || dirJar == null) continue;
            Utils.copyFileToDirectory((File)da.getFile(), (File)dirJar);
            Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dirJar.getPath());
            dependencies.add(da);
        }
        return dependencies;
    }

    public static String getFinalName(String name) {
        int in = name.lastIndexOf(".");
        name = in >= 0 ? name.substring(in + 1) + ".war" : name + ".war";
        return name;
    }

    public static void printMessage(String category, String message) {
        System.out.println("  [" + category + "]  " + message);
    }

    public static boolean containtFile(File parentDir, String childName) {
        String[] childFiles = parentDir.list();
        for (int i = 0; i < childFiles.length; ++i) {
            if (!childFiles[i].equals(childName)) continue;
            return true;
        }
        return false;
    }

    private static void deleteFileOnExist(File parentDir, String childName) throws IOException {
        File fileOld;
        if (Utils.containtFile(parentDir, childName)) {
            fileOld = new File(parentDir.getPath() + "/" + childName);
            Utils.printMessage("delete", "  Deleted file " + fileOld);
            Utils.deleteDirectory((File)fileOld);
        }
        if (Utils.containtFile(parentDir, childName + ".war")) {
            fileOld = new File(parentDir.getPath() + "/" + childName + ".war");
            Utils.printMessage("delete", "  Deleted file " + fileOld);
            fileOld.delete();
        }
    }

    public static int copyDirectoryStructure(File sourceDirectory, File destinationDirectory, HashSet<String> ignoreFiles) throws IOException {
        return Utils.copyDirectoryStructure(sourceDirectory, destinationDirectory, ignoreFiles, false);
    }

    public static int copyDirectoryStructure(File sourceDirectory, File destinationDirectory, HashSet<String> ignoreFiles, boolean overwrite) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        int counter = 0;
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                if (ignoreFiles.contains(file.getName())) continue;
                File fileInDst = new File(destination.getPath());
                if (fileInDst.exists()) {
                    if (overwrite && file.lastModified() > fileInDst.lastModified()) {
                        destination = destination.getParentFile();
                        Utils.copyFileToDirectory((File)file, (File)destination);
                        ++counter;
                    }
                    if (overwrite) continue;
                    destination = destination.getParentFile();
                    Utils.copyFileToDirectory((File)file, (File)destination);
                    ++counter;
                    continue;
                }
                destination = destination.getParentFile();
                Utils.copyFileToDirectory((File)file, (File)destination);
                ++counter;
                continue;
            }
            if (file.isDirectory()) {
                if (ignoreFiles.contains(file.getName())) continue;
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                counter += Utils.copyDirectoryStructure(file, destination, ignoreFiles, overwrite);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
        return counter;
    }

    public static int copyDirectoryStructure2(File sourceDirectory, File destinationDirectory, HashSet<String> ignoreFiles, boolean overwrite) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        int counter = 0;
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                if (ignoreFiles.contains(file.getName())) continue;
                destination = destination.getParentFile();
                Utils.copyFileToDirectory((File)file, (File)destination);
                ++counter;
                continue;
            }
            if (file.isDirectory()) {
                if (ignoreFiles.contains(file.getName())) continue;
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                counter += Utils.copyDirectoryStructure2(file, destination, ignoreFiles, overwrite);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
        return counter;
    }

    private static HashSet<Artifact> allDependencies(MavenProject project, HashSet<String> ignoreProjects) {
        if (ignoreProjects == null) {
            ignoreProjects = new HashSet();
        }
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        Set artifacts = project.getArtifacts();
        ArrayList list = new ArrayList();
        list.addAll(artifacts);
        Collections.sort(list);
        for (Artifact da : list) {
            if (da.getScope().equalsIgnoreCase("test") || ignoreProjects.contains(da.getArtifactId())) continue;
            dependencies.add(da);
        }
        return dependencies;
    }

    public static HashSet<String> getDefaultIgnoreFiles() {
        HashSet<String> ignoreProjects = new HashSet<String>();
        ignoreProjects.add(".svn");
        return ignoreProjects;
    }

    public static void createManifest(File mf, MavenProject project, HashSet ignoredProjects) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("Manifest-Version: 1.0\n");
        b.append("Ant-Version: Apache Ant 1.5.3\n");
        b.append("Created-By: 1.5.0_04-b05 (Sun Microsystems Inc.)\n");
        b.append("Class-Path: ");
        if (Utils.checkTypes(project)) {
            for (Artifact da : Utils.allDependencies(project, ignoredProjects)) {
                if (!da.getType().equals("jar")) continue;
                b.append(da.getArtifactId() + "-" + da.getVersion() + ".jar ");
            }
        }
        b.append("\n");
        b.append("Built-By: exo\n");
        b.append("Specification-Title: " + project.getArtifactId() + "\n");
        b.append("Specification-Version: " + project.getVersion() + "\n");
        b.append("Specification-Vendor: eXo Platform SARL\n");
        b.append("Implementation-Title: " + project.getBuild().getFinalName() + "\n");
        b.append("Implementation-Version: " + project.getVersion() + "\n");
        b.append("Implementation-Vendor: eXo Platform SARL\n");
        FileOutputStream out = new FileOutputStream(mf);
        out.write(b.toString().getBytes());
        out.close();
    }

    public static void createManifest2(File mf, MavenProject project, HashSet includes) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("Manifest-Version: 1.0\n");
        b.append("Ant-Version: Apache Ant 1.5.3\n");
        b.append("Created-By: 1.5.0_04-b05 (Sun Microsystems Inc.)\n");
        if (includes != null) {
            b.append("Class-Path: ");
            for (Artifact da : Utils.allDependencies(project, null)) {
                if (!da.getType().equals("jar") || !includes.contains(da.getArtifactId())) continue;
                b.append(da.getArtifactId() + "-" + da.getVersion() + ".jar ");
            }
            b.append("\n");
        }
        b.append("Built-By: exo\n");
        b.append("Specification-Title: " + project.getArtifactId() + "\n");
        b.append("Specification-Version: " + project.getVersion() + "\n");
        b.append("Specification-Vendor: eXo Platform SARL\n");
        b.append("Implementation-Title: " + project.getBuild().getFinalName() + "\n");
        b.append("Implementation-Version: " + project.getVersion() + "\n");
        b.append("Implementation-Vendor: eXo Platform SARL\n");
        FileOutputStream out = new FileOutputStream(mf);
        out.write(b.toString().getBytes());
        out.close();
    }

    public static void createApplicationXml(File earDir) throws IOException {
        File webInfDir = new File(earDir.getPath() + "/META-INF");
        webInfDir.mkdirs();
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        b.append("<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\">");
        b.append("\n<application>\n");
        b.append("  <display-name>exoplatform</display-name>\n");
        String[] file = earDir.list();
        for (int i = 0; i < file.length; ++i) {
            if (!file[i].endsWith("war")) continue;
            int idx = file[i].indexOf(46);
            String context = file[i].substring(0, idx);
            b.append("  <module>\n");
            b.append("    <web>\n");
            b.append("      <web-uri>").append(file[i]).append("</web-uri>\n");
            b.append("      <context-root>").append(context).append("</context-root>\n");
            b.append("    </web>\n");
            b.append("  </module>\n");
        }
        b.append("</application>\n");
        FileOutputStream out = new FileOutputStream(webInfDir.getPath() + "/application.xml");
        out.write(b.toString().getBytes());
        out.close();
    }

    public static void createApplicationXml2(File earDir) throws IOException {
        File webInfDir = new File(earDir.getPath() + "/META-INF");
        webInfDir.mkdirs();
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        b.append("<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\">");
        b.append("\n<application>\n");
        b.append("  <display-name>exoplatform</display-name>\n");
        String[] file = earDir.list();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].endsWith("war")) {
                int idx = file[i].indexOf(46);
                String context = file[i].substring(0, idx);
                b.append("  <module>\n");
                b.append("    <web>\n");
                b.append("      <web-uri>").append(file[i]).append("</web-uri>\n");
                b.append("      <context-root>").append(context).append("</context-root>\n");
                b.append("    </web>\n");
                b.append("  </module>\n");
                continue;
            }
            if (!file[i].endsWith("rar")) continue;
            b.append("  <module>\n");
            b.append("    <connector>").append(file[i]).append("</connector>\n");
            b.append("  </module>\n");
        }
        b.append("</application>\n");
        FileOutputStream out = new FileOutputStream(webInfDir.getPath() + "/application.xml");
        out.write(b.toString().getBytes());
        out.close();
    }

    public static void patchConfig(File src, File dest) throws Exception {
        Utils.printMessage("copy", " Patching configuration from " + src.getName());
        Utils.copyDirectoryStructure(src, dest, Utils.getDefaultIgnoreFiles());
    }

    public static void patchConfig2(File src, File dest) throws Exception {
        Utils.printMessage("copy", " Patching configuration from " + src.getName());
        Utils.copyDirectoryStructure2(src, dest, Utils.getDefaultIgnoreFiles(), true);
    }

    private static boolean checkTypes(MavenProject project) {
        return project.getPackaging().equals("war") || project.getPackaging().equals("exo-portal") || project.getPackaging().equals("exo-portlet") || project.getPackaging().equals("exo-jcr") || project.getPackaging().equals("exo-jcrrmi") || project.getPackaging().equals("exo-pc") || project.getPackaging().equals("ear");
    }

    public static void removeManifestFromJar(File file) throws IOException {
        Utils.printMessage("delete", " Removing Manifest from archive " + file.getAbsolutePath());
        File tempJarFile = new File(file.getAbsolutePath() + ".tmp");
        JarFile jar = new JarFile(file);
        JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
        byte[] buffer = new byte[1024];
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            int bytesRead;
            JarEntry entry = entries.nextElement();
            if ("META-INF/MANIFEST.MF".equalsIgnoreCase(entry.getName())) continue;
            InputStream entryStream = jar.getInputStream(entry);
            tempJar.putNextEntry(entry);
            while ((bytesRead = entryStream.read(buffer)) != -1) {
                tempJar.write(buffer, 0, bytesRead);
            }
        }
        jar.close();
        tempJar.close();
        file.delete();
        tempJarFile.renameTo(file);
    }
}

