/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ear.EarArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoJcrDeploy
extends AbstractMojo {
    private String workingDir;
    protected String outputDir;
    private String sharedResourcesDir;
    private String deploy;
    private String excludeProjects;
    private String includeToEar;
    protected MavenProject project;
    private String deployJbossDir;
    private String deployWLDir;
    private String serverWLDir;
    private String domainWLDir;
    private String jarsWLToLib;
    private String provsWL;
    private EarArchiver earArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException {
        if (!"exo-jcr".equals(this.project.getPackaging()) && !"exo-jcr2".equals(this.project.getPackaging())) {
            this.printInfo();
        }
        try {
            if (this.deploy != null) {
                this.execDeploy();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.printInfo();
    }

    protected void makeEar(File earFile, File webappDir, String outDir) throws Exception {
        this.getLog().info((CharSequence)("Generating ear " + earFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.earArchiver);
        archiver.setOutputFile(earFile);
        this.earArchiver.addDirectory(webappDir);
        this.earArchiver.setAppxml(new File(webappDir, "/META-INF/application.xml"));
        File manifest = new File(outDir + "/manifest.txt");
        Utils.createManifest(manifest, this.project, this.getIgnoreProjects());
        this.earArchiver.setManifest(manifest);
        archiver.createArchive(this.project, this.archive);
    }

    protected HashSet<String> getSet(String hs) {
        HashSet<String> set = new HashSet<String>();
        if (hs != null) {
            String[] pro;
            for (String s : pro = hs.split(",")) {
                set.add(s.trim());
            }
        }
        return set;
    }

    protected HashSet<String> getIgnoreProjects() {
        return this.getSet(this.excludeProjects);
    }

    protected HashSet<String> getIncludeToEar() {
        return this.getSet(this.includeToEar);
    }

    private void execDeploy() throws Exception {
        this.archive.setAddMavenDescriptor(false);
        if (this.deploy.equals("tomcat")) {
            File deployTomcatDirFile = new File(this.workingDir + "/exo-tomcat");
            this.deployTomcat(deployTomcatDirFile, this.getIgnoreProjects());
        } else if (this.deploy.equals("jonas")) {
            File deployJonasDirFile = new File(this.workingDir + "/exo-jonas");
            this.deployJonasEar(deployJonasDirFile, this.getIgnoreProjects());
        } else if (this.deploy.equals("jboss")) {
            File earDir = new File(this.deployJbossDir + "/jcr.sar");
            this.deployJbossEar(earDir, this.getIgnoreProjects());
        } else if (this.deploy.equals("wl")) {
            File earDir = new File(this.deployWLDir);
            this.deployWLEar(earDir, this.getIgnoreProjects());
        } else if (this.deploy.equals("jboss2")) {
            this.deployJboss2(this.deployJbossDir, this.getIgnoreProjects());
        } else if (this.deploy.equals("ear")) {
            this.deployEar(this.outputDir, this.getIgnoreProjects());
        } else {
            Utils.printMessage("info", "The task 'exo:jcr -Ddeploy=" + this.deploy + "' is invalid !\n");
            this.printInfo();
        }
    }

    protected void deployTomcat(File deployTomcatDir, HashSet<String> ignoreProjects) throws Exception {
        File directoryJar = new File(deployTomcatDir + "/common/lib");
        File directoryWar = new File(deployTomcatDir + "/webapps");
        directoryJar.mkdirs();
        directoryWar.mkdirs();
        Utils.deployedDependency2(directoryJar, null, null, this.project, ignoreProjects);
        Utils.deployProject(directoryJar, directoryWar, this.project, false, ignoreProjects);
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/patch-tomcat-jcr"), deployTomcatDir);
    }

    protected void deployJonas(File deployDir, HashSet<String> ignoreProjects) throws Exception {
        File warDir = new File(deployDir + "/webapps/autoload");
        File rarDir = new File(deployDir + "/rars/autoload");
        File libDir = new File(deployDir + "/lib/apps");
        warDir.mkdirs();
        rarDir.mkdirs();
        libDir.mkdirs();
        Utils.deployedDependency2(libDir, null, rarDir, this.project, ignoreProjects);
        Utils.deployProject(libDir, warDir, this.project, false, ignoreProjects);
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/patch-jonas-jcr"), deployDir);
    }

    protected void deployJonasEar(File deployDir, HashSet<String> ignoreProjects) throws Exception {
        File earDir = new File(deployDir + "/apps/autoload");
        earDir.mkdirs();
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/patch-jonas-jcr"), deployDir);
        this.deployEar(earDir.getAbsolutePath(), ignoreProjects);
    }

    protected void deployJboss(File earDir, HashSet<String> ignoreProjects) throws Exception {
        earDir.mkdirs();
        Utils.deployedDependency2(earDir, null, earDir, this.project, ignoreProjects);
        Utils.deployProject(earDir, earDir, this.project, false, ignoreProjects);
        Utils.createApplicationXml(earDir);
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/jcr.sar"), earDir);
    }

    protected void deployJbossEar(File earDir, HashSet<String> ignoreProjects) throws Exception {
        earDir.mkdirs();
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/jcr.sar"), earDir);
        this.deployEar(earDir.getAbsolutePath(), ignoreProjects);
    }

    protected void copyArtifactsToDir(String sJars, File dir) throws Exception {
        if (sJars != null && sJars.length() > 0) {
            HashSet<String> jars = this.getSet(sJars);
            Set artifacts = this.project.getArtifacts();
            ArrayList list = new ArrayList();
            list.addAll(artifacts);
            Collections.sort(list);
            for (Artifact da : list) {
                if (!jars.contains(da.getArtifactId())) continue;
                Utils.copyFileToDirectory((File)da.getFile(), (File)dir);
                Utils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + dir.getPath());
            }
        }
    }

    protected void deployWLEar(File earDir, HashSet<String> ignoreProjects) throws Exception {
        File serverDir = new File(this.serverWLDir + "/server/lib/mbeantypes");
        File domainDir = new File(this.domainWLDir + "/lib");
        earDir.mkdirs();
        this.deployEar(earDir.getAbsolutePath(), ignoreProjects);
        this.getLog().info((CharSequence)("Deploying jars to " + domainDir.getPath()));
        this.copyArtifactsToDir(this.jarsWLToLib, domainDir);
        this.getLog().info((CharSequence)("Deploying providers to " + serverDir.getPath()));
        this.copyArtifactsToDir(this.provsWL, serverDir);
    }

    protected void deployJboss2(String earDir, HashSet<String> ignoreProjects) throws Exception {
        File earFile = new File(earDir + "/jcr.ear");
        File outDir = new File(this.outputDir + "/ear");
        outDir.mkdirs();
        Utils.deployedDependency2(outDir, null, outDir, this.project, ignoreProjects);
        Utils.deployProject(outDir, outDir, this.project, false, ignoreProjects);
        Utils.createApplicationXml2(outDir);
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/jcr.sar"), outDir);
        this.makeEar(earFile, outDir, this.outputDir + "/ear");
    }

    protected void deployEar(String earDir, HashSet<String> ignoreProjects) throws Exception {
        File earFile = new File(earDir + "/jcr.ear");
        File outDir = new File(this.outputDir + "/ear");
        outDir.mkdirs();
        Utils.deployedDependency2(null, null, outDir, this.project, ignoreProjects);
        Utils.deployedDependency3(outDir, this.project, this.getIncludeToEar());
        Utils.deployProject(outDir, outDir, this.project, false, ignoreProjects);
        Utils.createApplicationXml2(outDir);
        Utils.patchConfig2(new File(this.sharedResourcesDir + "/ear"), outDir);
        this.makeEar(earFile, outDir, this.outputDir + "/ear");
    }

    private void printInfo() throws MojoExecutionException {
        String info = "The 'exo:jcr' maven2 plugin is used to assemble many exo modules into an application \nand deploy the application to a server. To run the command successfully, you need to\nrun the command in an exo-jcr module and all the dependencies modules must be built\nbefore running the command mvn exo:jcr -Ddeploy=value\n\nThe valid syntax is:\n  mvn exo:jcr -Ddeploy=tomcat\n  This command will copy the jcr module and the dependency modules to the tomcat server.\n  mvn exo:jcr -Ddeploy=jonas\n  This command deploys jcr standalone module EAR to JOnAS and applies server configuration patches.\n  mvn exo:jcr -Ddeploy=jboss\n  This command deploys jcr standalone module EAR and server configuration files to a JBoss SAR directory.\n  mvn exo:jcr -Ddeploy=jboss2\n  I don't remember what this command does, probably something strange and irrelevant at the time.\n  mvn exo:jcr -Ddeploy=wl\n  This command deploys jcr standalone module EAR to WebLogic and applies server configuration patches.\n  mvn exo:jcr -Ddeploy=ear\n  This command compiles jcr standalone module EAR in 'target' directory.\n";
        System.out.println(info);
        throw new MojoExecutionException("");
    }
}

