/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoJcrRmiDeploy
extends AbstractMojo {
    private String runDir;
    private String resDir;
    private String dest;
    private String excludeProjects;
    private String codebase;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        if (!"exo-jcrrmi".equals(this.project.getPackaging())) {
            this.printInfo();
        }
        try {
            if (this.dest != null) {
                this.execDeploy();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.printInfo();
    }

    protected HashSet<String> getIgnoreProjects() {
        HashSet<String> ignoreProjects = new HashSet<String>();
        if (this.excludeProjects != null) {
            String[] pro;
            for (String s : pro = this.excludeProjects.split(",")) {
                ignoreProjects.add(s.trim());
            }
        }
        return ignoreProjects;
    }

    protected HashSet<String> getCodeBase() {
        HashSet<String> codeBase = new HashSet<String>();
        if (codeBase != null) {
            String[] pro;
            for (String s : pro = this.codebase.split(",")) {
                codeBase.add(s.trim());
            }
        }
        return codeBase;
    }

    public void createBatch(File dir, String cp) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append("@echo off\n");
        b.append("set dbin=%~dp0\n");
        b.append("if \"%OS%\"==\"Windows_NT\" GOTO setcodebase\n");
        b.append("if \"%OS%\"==\"WINNT\" GOTO setcodebase\n");
        b.append("echo [WARN] Can not set codebase variable. Try to set codebase variable = absolute path to run/cb folder\n");
        b.append(":setcodebase\n");
        b.append("set dbin=%~dp0\n");
        b.append("set codebase=%dbin%cb\\\n");
        b.append(cp + "\n");
        b.append("java -Djava.security.auth.login.config=jaas.conf -Djava.rmi.server.codebase=file:/%codebase% -Djava.security.policy=java.policy org.exoplatform.connectors.jcr.RMIStarter bind configuration.xml\n");
        FileOutputStream out = new FileOutputStream(dir.getAbsolutePath() + "/run.bat");
        out.write(b.toString().getBytes());
        out.close();
    }

    public void extractJar(File dir, File file) throws IOException {
        Utils.printMessage("extract", "  Extracting jar '" + file.getName() + "'");
        File tempJarFile = new File(file.getAbsolutePath() + ".tmp");
        JarFile jar = new JarFile(file);
        byte[] buffer = new byte[1024];
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            int bytesRead;
            JarEntry entry = entries.nextElement();
            if (entry.getName().startsWith("META-INF/") || entry.isDirectory()) continue;
            InputStream entryStream = jar.getInputStream(entry);
            File outFile = new File(dir.getAbsolutePath() + "/" + entry.getName());
            outFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(outFile);
            while ((bytesRead = entryStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.close();
        }
        jar.close();
    }

    public void createCodebase(File dir, List cbas) throws IOException {
        int j = 0;
        for (File jar : cbas) {
            this.extractJar(dir, jar);
            ++j;
        }
        Utils.printMessage("info", "  " + j + " jars extracted");
    }

    protected void makeRmiDir() throws Exception {
        File _runDir = new File(this.runDir);
        File _resDir = new File(this.resDir);
        File _libDir = new File(this.runDir + "/lib");
        File _cbDir = new File(this.runDir + "/cb");
        _libDir.mkdirs();
        _cbDir.mkdirs();
        HashSet<String> ignoreProjects = this.getIgnoreProjects();
        HashSet<String> codeBase = this.getCodeBase();
        String classpath = "set CLASSPATH=%CLASSPATH%;.";
        ArrayList<File> cbas = new ArrayList<File>();
        Set artifacts = this.project.getArtifacts();
        ArrayList list = new ArrayList();
        list.addAll(artifacts);
        Collections.sort(list);
        for (Artifact da : list) {
            String projectType;
            if (da.getScope().equalsIgnoreCase("test") || ignoreProjects.contains(da.getArtifactId()) || !"jar".equals(projectType = da.getType())) continue;
            classpath = classpath + ";lib/" + da.getFile().getName();
            Utils.copyFileToDirectory((File)da.getFile(), (File)_libDir);
            Utils.printMessage("copy", "  Copied file '" + da.getFile().getName() + "' to lib dir");
            if (!codeBase.contains(da.getArtifactId())) continue;
            cbas.add(da.getFile());
        }
        Utils.patchConfig2(_resDir, _runDir);
        Utils.printMessage("create", "  Creating batch file 'run.bat' in '" + _runDir.getAbsolutePath() + "'");
        this.createBatch(_runDir, classpath);
        Utils.printMessage("create", "  Creating codebase in '" + _cbDir.getAbsolutePath() + "'");
        this.createCodebase(_cbDir, cbas);
    }

    private void execDeploy() throws Exception {
        if (this.dest.equals("rmisrv")) {
            this.makeRmiDir();
        } else {
            Utils.printMessage("info", "The task 'exo:jcrrmi -Ddest=" + this.dest + "' is invalid !\n");
            this.printInfo();
        }
    }

    private void printInfo() throws MojoExecutionException {
        String info = "The valid syntax is:\n  mvn exo:jcrrmi -Ddest=rmisrv\n";
        System.out.println(info);
        throw new MojoExecutionException("");
    }
}

