/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.util.HashSet;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoPCWar
extends AbstractMojo {
    protected String outputDirectory;
    private File warSourceDirectory;
    private String warName;
    private String excludeProjects;
    private WarArchiver warArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProject project;

    protected HashSet<String> getSet(String hs) {
        HashSet<String> set = new HashSet<String>();
        if (hs != null) {
            String[] pro;
            for (String s : pro = hs.split(",")) {
                set.add(s.trim());
            }
        }
        return set;
    }

    protected HashSet<String> getIgnoreProjects() {
        return this.getSet(this.excludeProjects);
    }

    protected void performPackaging(File warFile, File webappDir) throws Exception {
        this.getLog().info((CharSequence)("Generating war " + warFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(warFile);
        this.warArchiver.addDirectory(webappDir);
        this.warArchiver.setWebxml(new File(webappDir, "WEB-INF/web.xml"));
        File manifest = new File(this.outputDirectory + "/manifest.txt");
        Utils.createManifest(manifest, this.project, this.getIgnoreProjects());
        this.warArchiver.setManifest(manifest);
        this.archive.setAddMavenDescriptor(false);
        archiver.createArchive(this.project, this.archive);
        this.project.getArtifact().setFile(warFile);
    }

    public void execute() throws MojoExecutionException {
        try {
            File webappClassDest;
            File webappDest = new File(this.outputDirectory + "/" + this.warName);
            Utils.copyDirectoryStructure(this.warSourceDirectory, webappDest, Utils.getDefaultIgnoreFiles());
            File classesSrc = new File(this.outputDirectory + "/classes");
            if (!classesSrc.exists()) {
                classesSrc.mkdir();
            }
            if (!(webappClassDest = new File(this.outputDirectory + "/" + this.warName + "/WEB-INF/classes")).exists()) {
                webappClassDest.mkdir();
            }
            FileUtils.copyDirectoryStructure((File)classesSrc, (File)webappClassDest);
            File warFile = new File(this.outputDirectory, this.warName + ".war");
            this.performPackaging(warFile, webappDest);
        }
        catch (Exception exe) {
            throw new MojoExecutionException("Error", exe);
        }
    }
}

