/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.util.HashSet;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExoPackaging
extends AbstractMojo {
    protected String outputDirectory;
    private WarArchiver warArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProject project;
    private String excludeProjects;

    protected void performPackaging(File warFile, File webappDir) throws Exception {
        this.getLog().info((CharSequence)("Generating war " + warFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(warFile);
        this.warArchiver.addDirectory(webappDir);
        this.warArchiver.setWebxml(new File(webappDir, "WEB-INF/web.xml"));
        File manifest = new File(this.outputDirectory + "/manifest.txt");
        Utils.createManifest(manifest, this.project, this.getIgnoreProjects());
        this.warArchiver.setManifest(manifest);
        archiver.createArchive(this.project, this.archive);
        this.project.getArtifact().setFile(warFile);
    }

    protected HashSet<String> getIgnoreProjects() {
        HashSet<String> ignoreProjects = new HashSet<String>();
        if (this.excludeProjects != null) {
            String[] pro;
            for (String s : pro = this.excludeProjects.split(",")) {
                ignoreProjects.add(s.trim());
            }
        }
        return ignoreProjects;
    }
}

