/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.util.HashSet;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ear.EarArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoPcDeploy
extends AbstractMojo {
    private String workingDir;
    protected String outputDir;
    private String sharedDir;
    private String deploy;
    private String excludeProjects;
    private String includeWars;
    private String finalName;
    protected MavenProject project;
    private EarArchiver earArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public void execute() throws MojoExecutionException {
        try {
            if (this.deploy != null) {
                this.execDeploy();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.printInfo();
    }

    protected void makeEar(File earFile, File webappDir, String outDir) throws Exception {
        this.getLog().info((CharSequence)("Generating ear " + earFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.earArchiver);
        archiver.setOutputFile(earFile);
        this.earArchiver.addDirectory(webappDir);
        this.earArchiver.setAppxml(new File(webappDir, "/META-INF/application.xml"));
        File manifest = new File(outDir + "/manifest.txt");
        this.getLog().info((CharSequence)("Creating manifest " + manifest.getAbsolutePath()));
        Utils.createManifest(manifest, this.project, this.getIgnoreProjects());
        this.earArchiver.setManifest(manifest);
        archiver.createArchive(this.project, this.archive);
    }

    protected HashSet<String> getSet(String hs) {
        HashSet<String> set = new HashSet<String>();
        if (hs != null) {
            String[] pro;
            for (String s : pro = hs.split(",")) {
                set.add(s.trim());
            }
        }
        return set;
    }

    protected HashSet<String> getIgnoreProjects() {
        return this.getSet(this.excludeProjects);
    }

    protected HashSet<String> getIncludeWars() {
        return this.getSet(this.includeWars);
    }

    private void execDeploy() throws Exception {
        this.archive.setAddMavenDescriptor(false);
        if (this.deploy.equals("tomcat")) {
            File deployTomcatDirFile = new File(this.workingDir + "/exo-tomcat");
            this.deployTomcat(deployTomcatDirFile, this.getIgnoreProjects());
        } else if (this.deploy.equals("ear")) {
            this.deployEar(this.outputDir, this.getIgnoreProjects());
        } else {
            Utils.printMessage("info", "The task 'exo:pc -Ddeploy=" + this.deploy + "' is invalid !\n");
            this.printInfo();
        }
    }

    protected void deployTomcat(File deployTomcatDir, HashSet<String> ignoreProjects) throws Exception {
        File directoryJar = new File(deployTomcatDir + "/common/lib");
        File directoryWar = new File(deployTomcatDir + "/webapps");
        directoryJar.mkdirs();
        directoryWar.mkdirs();
        Utils.deployedDependency2(directoryJar, directoryWar, null, this.project, ignoreProjects);
        if (this.sharedDir != null && !this.sharedDir.equals("")) {
            Utils.patchConfig2(new File(this.sharedDir + "/tomcat"), deployTomcatDir);
        }
    }

    protected void deployEar(String earDir, HashSet<String> ignoreProjects) throws Exception {
        File earFile = new File(earDir + "/" + this.finalName + ".ear");
        File outDir = new File(this.outputDir + "/ear");
        outDir.mkdirs();
        Utils.deployedDependency2(outDir, outDir, outDir, this.project, ignoreProjects);
        Utils.createApplicationXml2(outDir);
        if (this.sharedDir != null && !this.sharedDir.equals("")) {
            Utils.patchConfig2(new File(this.sharedDir + "/ear"), outDir);
        }
        this.makeEar(earFile, outDir, this.outputDir + "/ear");
    }

    private void printInfo() throws MojoExecutionException {
        String info = "The 'exo:pc' maven2 plugin is used to assemble many exo modules into an application.\nTo run the command successfully, you need to\nrun the command in an exo-pc module and all the dependencies modules must be built\nbefore running the command mvn exo:pc -Ddeploy=value\n\nThe valid syntax is:\n  mvn exo:pc -Ddeploy=tomcat\n  This command will copy the pc module and the dependency modules to the tomcat server.\n  mvn exo:pc -Ddeploy=ear\n  This command compiles pc standalone module EAR in 'target' directory.\n";
        System.out.println(info);
        throw new MojoExecutionException("");
    }
}

