/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoPlatform
extends AbstractMojo {
    private String workingDir;
    private String sharedResourcesDir;
    private String deploy;
    private String excludeProjects;
    protected MavenProject project;
    private String cleanTomcatDir;
    private String cleanJonasDir;
    private String deployJonasDir;
    private String deployJbossDir;

    public void execute() throws MojoExecutionException {
        if (!"exo-portal".equals(this.project.getPackaging())) {
            this.printInfo();
        }
        try {
            if (this.deploy != null) {
                this.execDeploy();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.printInfo();
    }

    protected HashSet<String> getIgnoreProjects() {
        HashSet<String> ignoreProjects = new HashSet<String>();
        if (this.excludeProjects != null) {
            String[] pro;
            for (String s : pro = this.excludeProjects.split(",")) {
                ignoreProjects.add(s.trim());
            }
        }
        return ignoreProjects;
    }

    private void execDeploy() throws Exception {
        if (this.deploy.equals("newTomcat")) {
            File deployTomcatDirFile = new File(this.workingDir + "/exo-tomcat");
            File cleanTomcatDirFile = new File(this.cleanTomcatDir);
            if (deployTomcatDirFile.exists()) {
                Utils.printMessage("deleting", "  Deleting directory " + deployTomcatDirFile.getPath());
                Utils.deleteDirectory((File)deployTomcatDirFile);
            }
            Utils.printMessage("mkdir", "  " + deployTomcatDirFile.getPath());
            Utils.printMessage("copy", "  Copy directory " + cleanTomcatDirFile.getName() + " to " + deployTomcatDirFile.getPath());
            Utils.copyDirectoryStructure((File)cleanTomcatDirFile, (File)deployTomcatDirFile);
        } else if (this.deploy.equals("tomcat")) {
            File deployTomcatDirFile = new File(this.workingDir + "/exo-tomcat");
            this.deployTomcat(deployTomcatDirFile, this.getIgnoreProjects());
        } else if (this.deploy.equals("newJonas")) {
            File deployJonasDirFile = new File(this.deployJonasDir);
            File cleanJonasDirFile = new File(this.cleanJonasDir);
            if (deployJonasDirFile.exists()) {
                Utils.printMessage("deleting", "  Deleting directory " + deployJonasDirFile.getPath());
                Utils.deleteDirectory((File)deployJonasDirFile);
            }
            Utils.printMessage("mkdir", "  " + deployJonasDirFile.getPath());
            Utils.printMessage("copy", "  Copy directory " + cleanJonasDirFile.getName() + " to " + deployJonasDirFile.getPath());
            Utils.copyDirectoryStructure((File)cleanJonasDirFile, (File)deployJonasDirFile);
        } else if (this.deploy.equals("jonas")) {
            File deployJonasDirFile = new File(this.deployJonasDir);
            this.deployJonas(deployJonasDirFile, this.getIgnoreProjects());
        } else if (this.deploy.equals("jboss")) {
            File earDir = new File(this.deployJbossDir + "/exoplatform.sar");
            this.deployJboss(earDir, this.getIgnoreProjects());
        } else {
            Utils.printMessage("info", "The task 'exo:platform -Ddeploy=" + this.deploy + "' is invalid !\n");
            this.printInfo();
        }
    }

    protected void deployTomcat(File deployTomcatDir, HashSet<String> ignoreProjects) throws Exception {
        File directoryJar = new File(deployTomcatDir + "/common/lib");
        File directoryWar = new File(deployTomcatDir + "/webapps");
        directoryJar.mkdirs();
        directoryWar.mkdirs();
        Utils.deployProject(directoryJar, directoryWar, this.project, true, ignoreProjects);
        Utils.patchConfig(new File(this.sharedResourcesDir + "/patch-tomcat"), deployTomcatDir);
        String contextName = this.project.getBuild().getFinalName();
        FileInputStream is = new FileInputStream(deployTomcatDir + "/conf/Catalina/localhost/portal.template");
        byte[] buf = new byte[is.available()];
        is.read(buf);
        is.close();
        String s = new String(buf).replace("@context@", contextName);
        FileOutputStream os = new FileOutputStream(deployTomcatDir + "/conf/Catalina/localhost/" + contextName + ".xml");
        os.write(s.getBytes());
        os.close();
    }

    protected void deployJonas(File deployDir, HashSet<String> ignoreProjects) throws Exception {
        File earDir = new File(deployDir + "/apps/autoload/exoplatform.ear");
        File libDir = new File(deployDir + "/lib/apps");
        earDir.mkdirs();
        libDir.mkdirs();
        Utils.deployProject(libDir, earDir, this.project, true, ignoreProjects);
        Utils.createApplicationXml(earDir);
        Utils.patchConfig(new File(this.sharedResourcesDir + "/patch-jonas"), deployDir);
        File[] files = earDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().endsWith("war")) continue;
            Utils.removeManifestFromJar(files[i]);
        }
    }

    protected void deployJboss(File earDir, HashSet<String> ignoreProjects) throws Exception {
        earDir.mkdirs();
        Utils.deployProject(earDir, earDir, this.project, true, ignoreProjects);
        Utils.createApplicationXml(earDir);
        Utils.patchConfig(new File(this.sharedResourcesDir + "/exoplatform.sar"), earDir);
    }

    private void printInfo() throws MojoExecutionException {
        String info = "The 'exo:platform' maven2 plugin is used to assemble many exo modules into an application \nand deploy the application to a server. To run the command successfully, you need to\nrun the command in an exo-portal type module and all the dependencies modules must be built\nbefore running the command mvn exo:platform -Dparam=value\n\nThe valid syntax is:\n  mvn exo:platform -Ddeploy=newTomcat\n  This command will create a new clean tomcat in the exo-working directory.\n  mvn exo:platform -Ddeploy=tomcat\n  This command will copy will copy the portal module and the dependency module to the tomcat server.\n  mvn exo:platform -Ddeploy=newJonas\n  This command will create a new clean jonas in the exo-working directory.\n  mvn exo:platform -Ddeploy=jonas\n  This command will copy will copy the portal module and the dependency module to the jonas server.\n  mvn exo:platform -Ddeploy=jboss\n  This command will copy will copy the portal module and the dependency module to the jboss server.\n";
        System.out.println(info);
        throw new MojoExecutionException("");
    }
}

