/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.exoplatform.maven2.plugin.ExecuteConfig;
import org.exoplatform.maven2.plugin.ExoFileUtils;

public class ExoExecute
extends AbstractMojo {
    protected MavenProject project;
    private List<ExecuteConfig> executeConfigs;

    public void execute() throws MojoExecutionException {
        ExecuteConfig select = null;
        String selectId = System.getProperty("executeId");
        if (selectId == null) {
            selectId = "default";
        }
        for (ExecuteConfig config : this.executeConfigs) {
            if (!config.getExecuteId().equals(selectId)) continue;
            select = config;
            break;
        }
        if (select == null) {
            System.out.println("You need to specify the id  of  the execution or have an execution with 'default' as id");
            return;
        }
        this.execute(select);
    }

    private void execute(ExecuteConfig config) throws MojoExecutionException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        List<String> classpaths = config.getClasspaths();
        Map<String, String> sysproperties = config.getSysproperties();
        try {
            Set set = this.project.getArtifacts();
            Iterator itr = set.iterator();
            ArrayList<URL> urls = new ArrayList<URL>();
            StringBuilder sysclasspath = new StringBuilder();
            String pathSeparator = System.getProperty("path.separator");
            sysclasspath.append(System.getProperty("java.class.path"));
            while (itr.hasNext()) {
                Artifact art = (Artifact)itr.next();
                urls.add(new URL("file:" + art.getFile().getPath()));
                sysclasspath.append(pathSeparator).append(art.getFile().getPath());
            }
            if (classpaths != null) {
                for (String path : classpaths) {
                    urls.add(new URL("file:" + path));
                    sysclasspath.append(pathSeparator).append(path);
                }
            }
            System.setProperty("java.class.path", sysclasspath.toString());
            URLClassLoader newCl = new URLClassLoader(urls.toArray(new URL[urls.size()]), oldCl);
            Thread.currentThread().setContextClassLoader(newCl);
            if (sysproperties != null && sysproperties.size() > 0) {
                for (Map.Entry entry : sysproperties.entrySet()) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (String string : config.getScripts()) {
                if (string.endsWith(".class")) {
                    String className = string.substring(0, string.indexOf(".class"));
                    Object obj = newCl.loadClass(className).newInstance();
                    if (obj instanceof Runnable) {
                        ((Runnable)obj).run();
                        continue;
                    }
                    throw new Exception("Cannot execute : " + obj);
                }
                Binding binding = new Binding();
                binding.setVariable("FileUtil", ExoFileUtils.class);
                binding.setVariable("project", (Object)this.project);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate(string);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("FALSE", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

