/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.xml;

import org.exoplatform.tools.xml.ModificationTaskException;
import org.jaxen.JaxenException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public abstract class XMLModificationTask {
    public static final String CLASS_VERSION = "$Id: XMLModificationTask.java,v 1.1 2004/04/19 03:45:49 hatimk Exp $";
    protected static final int NOMODIFICATION = 0;
    protected static final int REPLACE = 1;
    protected static final int INSERT = 2;

    public boolean needModification(Document pDoc) throws ModificationTaskException {
        boolean modify = false;
        try {
            int detectStatus = this.detect(pDoc);
            switch (detectStatus) {
                case 1: {
                    modify = true;
                    break;
                }
                case 2: {
                    modify = true;
                    break;
                }
                default: {
                    modify = false;
                    break;
                }
            }
        }
        catch (JaxenException e) {
            throw new ModificationTaskException("Unable to process the DOM document " + e.getMessage(), e);
        }
        return modify;
    }

    public boolean modify(Document pDoc) throws ModificationTaskException {
        boolean result = false;
        try {
            int detectStatus = this.detect(pDoc);
            switch (detectStatus) {
                case 1: {
                    this.replace(pDoc);
                    result = true;
                    break;
                }
                case 2: {
                    this.insert(pDoc);
                    result = true;
                }
            }
        }
        catch (JaxenException e) {
            throw new ModificationTaskException("Unable to modify the DOM document" + e.getMessage(), e);
        }
        return result;
    }

    protected abstract int detect(Document var1) throws JaxenException;

    protected abstract void insert(Document var1) throws JaxenException;

    protected abstract void replace(Document var1) throws JaxenException;

    protected static String getTextContent(Node pNode) {
        Node current;
        Document doc = pNode.getOwnerDocument();
        DocumentTraversal traversable = (DocumentTraversal)((Object)doc);
        int whatToShow = 12;
        NodeIterator iterator = traversable.createNodeIterator(pNode, whatToShow, null, false);
        StringBuffer result = new StringBuffer();
        while ((current = iterator.nextNode()) != null) {
            result.append(current.getNodeValue());
        }
        return result.toString();
    }
}

