/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.jar.JarSignMojo;
import org.apache.maven.plugin.jar.JarSignVerifyMojo;
import org.apache.maven.plugin.jar.JarSignVerifyMojoTest;
import org.apache.maven.plugin.jar.MockArtifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JarSignMojoTest
extends TestCase {
    private MockJarSignMojo mojo;

    public void setUp() throws IOException {
        this.mojo = new MockJarSignMojo();
        this.mojo.executeResult = 0;
        File basedir = new File(System.getProperty("java.io.tmpdir"));
        this.mojo.setBasedir(basedir);
        this.mojo.setWorkingDir(basedir);
        this.mojo.setSignedJar(new File("/tmp/signed/file-version.jar"));
        this.mojo.setAlias("alias");
        this.mojo.setKeystore("/tmp/keystore");
        this.mojo.setKeypass("secretpassword");
        MavenProject project = new MavenProject(new Model());
        MockArtifact mockArtifact = new MockArtifact();
        mockArtifact.setGroupId("test");
        mockArtifact.setArtifactId("test");
        mockArtifact.setVersion("1.0");
        mockArtifact.setType("jar");
        project.setArtifact((Artifact)mockArtifact);
        this.mojo.setProject(project);
        new File(this.getDummyNonSignedJarPath()).delete();
    }

    public void tearDown() {
        this.mojo = null;
    }

    public void testRunOK() throws MojoExecutionException {
        JarSignVerifyMojoTest.MockJarSignVerifyMojo mockJarSignVerifyMojo = new JarSignVerifyMojoTest.MockJarSignVerifyMojo();
        this.mojo.verifyMojo = mockJarSignVerifyMojo;
        this.mojo.execute();
        String[] expectedArguments = new String[]{"-keystore", "/tmp/keystore", "-keypass", "secretpassword", "-signedjar", "/tmp/signed/file-version.jar", this.getDummyNonSignedJarPath(), "alias"};
        this.checkMojo(expectedArguments);
        JarSignMojoTest.assertEquals((String)"sign operation wasn't verified", (int)0, (int)mockJarSignVerifyMojo.commandLines.size());
    }

    public void testVerifyJarGeneratedBySignOperation() throws MojoExecutionException {
        JarSignVerifyMojoTest.MockJarSignVerifyMojo mockJarSignVerifyMojo = new JarSignVerifyMojoTest.MockJarSignVerifyMojo();
        this.mojo.verifyMojo = mockJarSignVerifyMojo;
        this.mojo.setVerify(true);
        mockJarSignVerifyMojo.lastOutLine = "jar verified.";
        this.mojo.execute();
        String[] expectedArguments = new String[]{"-keystore", "/tmp/keystore", "-keypass", "secretpassword", "-signedjar", "/tmp/signed/file-version.jar", this.getDummyNonSignedJarPath(), "alias"};
        this.checkMojo(expectedArguments);
        String[] expectedVerifyArguments = new String[]{"-verify", "/tmp/signed/file-version.jar"};
        JarSignVerifyMojoTest.checkMojo(mockJarSignVerifyMojo, expectedVerifyArguments);
    }

    public void testVerifyInPlaceSignedJar() throws MojoExecutionException {
        JarSignVerifyMojoTest.MockJarSignVerifyMojo mockJarSignVerifyMojo = new JarSignVerifyMojoTest.MockJarSignVerifyMojo();
        this.mojo.verifyMojo = mockJarSignVerifyMojo;
        this.mojo.setSignedJar(null);
        this.mojo.setVerify(true);
        mockJarSignVerifyMojo.lastOutLine = "jar verified.";
        this.mojo.execute();
        String[] expectedArguments = new String[]{"-keystore", "/tmp/keystore", "-keypass", "secretpassword", this.getDummyNonSignedJarPath(), "alias"};
        this.checkMojo(expectedArguments);
        String[] expectedVerifyArguments = new String[]{"-verify", this.getDummyNonSignedJarPath()};
        JarSignVerifyMojoTest.checkMojo(mockJarSignVerifyMojo, expectedVerifyArguments);
    }

    public void testRunTwice() throws MojoExecutionException, IOException {
        this.mojo.execute();
        class MyJarSignVerifyMojo
        extends JarSignVerifyMojo {
            int nbExecutions;

            MyJarSignVerifyMojo() {
            }

            public void execute() throws MojoExecutionException {
                ++this.nbExecutions;
            }

            public boolean isSigned() {
                return true;
            }
        }
        this.mojo.verifyMojo = new MyJarSignVerifyMojo();
        new File(this.getDummyNonSignedJarPath()).createNewFile();
        this.mojo.execute();
        String[] expectedArguments = new String[]{"-keystore", "/tmp/keystore", "-keypass", "secretpassword", "-signedjar", "/tmp/signed/file-version.jar", this.getDummyNonSignedJarPath(), "alias"};
        this.checkMojo(expectedArguments);
    }

    public void testRunFailure() {
        JarSignVerifyMojoTest.MockJarSignVerifyMojo mockJarSignVerifyMojo = new JarSignVerifyMojoTest.MockJarSignVerifyMojo();
        this.mojo.verifyMojo = mockJarSignVerifyMojo;
        this.mojo.executeResult = 1;
        this.mojo.setAlias(null);
        try {
            this.mojo.execute();
            JarSignMojoTest.fail((String)"expected failure");
        }
        catch (MojoExecutionException e) {
            JarSignMojoTest.assertTrue((boolean)e.getMessage().startsWith("Result of "));
        }
        String[] expectedArguments = new String[]{"-keystore", "/tmp/keystore", "-keypass", "secretpassword", "-signedjar", "/tmp/signed/file-version.jar", this.getDummyNonSignedJarPath()};
        this.checkMojo(expectedArguments);
        JarSignMojoTest.assertEquals((String)"sign operation wasn't verified", (int)0, (int)mockJarSignVerifyMojo.commandLines.size());
    }

    private String getDummyNonSignedJarPath() {
        String value = System.getProperty("java.io.tmpdir");
        if (!value.endsWith("\\") && !value.endsWith("/")) {
            value = String.valueOf(value) + "/";
        }
        value = String.valueOf(value) + "null.jar";
        return value;
    }

    public void testRunError() {
        this.mojo.failureMsg = "simulated failure";
        try {
            this.mojo.execute();
            JarSignMojoTest.fail((String)"expected failure");
        }
        catch (MojoExecutionException e) {
            JarSignMojoTest.assertEquals((String)"command execution failed", (String)e.getMessage());
        }
        String[] expectedArguments = new String[]{"-keystore", "/tmp/keystore", "-keypass", "secretpassword", "-signedjar", "/tmp/signed/file-version.jar", this.getDummyNonSignedJarPath(), "alias"};
        this.checkMojo(expectedArguments);
    }

    private void checkMojo(String[] expectedCommandLineArguments) {
        JarSignMojoTest.assertEquals((int)1, (int)this.mojo.commandLines.size());
        Commandline commandline = (Commandline)this.mojo.commandLines.get(0);
        String[] arguments = commandline.getArguments();
        JarSignMojoTest.assertEquals((String)"Differing number of arguments", (int)expectedCommandLineArguments.length, (int)arguments.length);
        int i = 0;
        while (i < arguments.length) {
            JarSignMojoTest.assertEquals((String)expectedCommandLineArguments[i].replace('\\', '/'), (String)arguments[i].replace('\\', '/'));
            ++i;
        }
    }

    static class MockJarSignMojo
    extends JarSignMojo {
        public int executeResult;
        public List commandLines = new ArrayList();
        public String failureMsg;
        public Map systemProperties = new HashMap();
        public JarSignVerifyMojo verifyMojo = new JarSignVerifyMojo();

        MockJarSignMojo() {
        }

        protected int executeCommandLine(Commandline commandLine, InputStream inputStream, StreamConsumer stream1, StreamConsumer stream2) throws CommandLineException {
            this.commandLines.add(commandLine);
            if (this.failureMsg != null) {
                throw new CommandLineException(this.failureMsg);
            }
            return this.executeResult;
        }

        protected JarSignVerifyMojo createJarSignVerifyMojo() {
            return this.verifyMojo;
        }

        protected String getSystemProperty(String key) {
            return (String)this.systemProperties.get(key);
        }
    }
}

