/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.plugins.javadoc.JavadocUtil;
import org.apache.maven.plugins.javadoc.options.JavadocOptions;
import org.apache.maven.plugins.javadoc.options.io.xpp3.JavadocOptionsXpp3Reader;
import org.apache.maven.plugins.javadoc.resolver.JavadocBundle;
import org.apache.maven.plugins.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ResourceResolver.class)
public final class ResourceResolver
extends AbstractLogEnabled {
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver resolver;
    @Requirement
    private DependencyResolver dependencyResolver;
    @Requirement
    private ArtifactMetadataSource artifactMetadataSource;
    @Requirement
    private ArchiverManager archiverManager;
    public static final String SOURCES_CLASSIFIER = "sources";
    public static final String TEST_SOURCES_CLASSIFIER = "test-sources";
    private static final List<String> SOURCE_VALID_CLASSIFIERS = Arrays.asList("sources", "test-sources");
    private static final List<String> RESOURCE_VALID_CLASSIFIERS = Arrays.asList("javadoc-resources", "test-javadoc-resources");

    public List<JavadocBundle> resolveDependencyJavadocBundles(SourceResolverConfig config) throws IOException {
        ArrayList<JavadocBundle> bundles = new ArrayList<JavadocBundle>();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        if (config.reactorProjects() != null) {
            for (MavenProject p : config.reactorProjects()) {
                projectMap.put(ResourceResolver.key(p.getGroupId(), p.getArtifactId()), p);
            }
        }
        List artifacts = config.project().getTestArtifacts();
        ArrayList<Artifact> forResourceResolution = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            String key = ResourceResolver.key(artifact.getGroupId(), artifact.getArtifactId());
            MavenProject p = (MavenProject)projectMap.get(key);
            if (p != null) {
                bundles.addAll(ResourceResolver.resolveBundleFromProject(config, p, artifact));
                continue;
            }
            forResourceResolution.add(artifact);
        }
        bundles.addAll(this.resolveBundlesFromArtifacts(config, forResourceResolution));
        return bundles;
    }

    public Map<String, Collection<Path>> resolveDependencySourcePaths(SourceResolverConfig config) throws ArtifactResolutionException, ArtifactNotFoundException {
        LinkedHashMap<String, Collection<Path>> mappedDirs = new LinkedHashMap<String, Collection<Path>>();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        if (config.reactorProjects() != null) {
            for (MavenProject p : config.reactorProjects()) {
                projectMap.put(ResourceResolver.key(p.getGroupId(), p.getArtifactId()), p);
            }
        }
        List artifacts = config.project().getTestArtifacts();
        ArrayList<Artifact> forResourceResolution = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            String key = ResourceResolver.key(artifact.getGroupId(), artifact.getArtifactId());
            MavenProject p = (MavenProject)projectMap.get(key);
            if (p != null) {
                mappedDirs.put(key, ResourceResolver.resolveFromProject(config, p, artifact));
                continue;
            }
            forResourceResolution.add(artifact);
        }
        for (Map.Entry entry : this.resolveFromArtifacts(config, forResourceResolution)) {
            mappedDirs.put((String)entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return mappedDirs;
    }

    private static List<JavadocBundle> resolveBundleFromProject(SourceResolverConfig config, MavenProject project, Artifact artifact) throws IOException {
        ArrayList<JavadocBundle> bundles = new ArrayList<JavadocBundle>();
        ArrayList<String> classifiers = new ArrayList<String>();
        if (config.includeCompileSources()) {
            classifiers.add("javadoc-resources");
        }
        if (config.includeTestSources()) {
            classifiers.add("test-javadoc-resources");
        }
        for (String classifier : classifiers) {
            File optionsFile = new File(project.getBuild().getDirectory(), "javadoc-bundle-options/javadoc-options-" + classifier + ".xml");
            if (!optionsFile.exists()) continue;
            try {
                FileInputStream stream = new FileInputStream(optionsFile);
                Throwable throwable = null;
                try {
                    JavadocOptions options = new JavadocOptionsXpp3Reader().read(stream);
                    bundles.add(new JavadocBundle(options, new File(project.getBasedir(), options.getJavadocResourcesDirectory())));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (XmlPullParserException e) {
                IOException error = new IOException("Failed to read javadoc options from: " + optionsFile + "\nReason: " + e.getMessage(), e);
                throw error;
            }
        }
        return bundles;
    }

    private List<JavadocBundle> resolveBundlesFromArtifacts(SourceResolverConfig config, List<Artifact> artifacts) throws IOException {
        ArrayList<String> dirs;
        block21: {
            ArrayList<Artifact> toResolve = new ArrayList<Artifact>(artifacts.size());
            for (Artifact artifact : artifacts) {
                if (config.filter() != null && !new ArtifactIncludeFilterTransformer().transform(config.filter()).include(artifact)) continue;
                if (config.includeCompileSources()) {
                    toResolve.add(this.createResourceArtifact(artifact, "javadoc-resources", config));
                }
                if (!config.includeTestSources()) continue;
                toResolve.add(this.createResourceArtifact(artifact, "test-javadoc-resources", config));
            }
            dirs = new ArrayList<String>(toResolve.size());
            try {
                for (Map.Entry<String, Path> entry : this.resolveAndUnpack(toResolve, config, RESOURCE_VALID_CLASSIFIERS, false)) {
                    dirs.add(entry.getValue().toString());
                }
            }
            catch (ArtifactNotFoundException | ArtifactResolutionException throwable) {
                if (!this.getLogger().isDebugEnabled()) break block21;
                this.getLogger().debug(throwable.getMessage(), throwable);
            }
        }
        ArrayList<JavadocBundle> arrayList = new ArrayList<JavadocBundle>();
        for (String d : dirs) {
            File dir = new File(d);
            File resources = new File(dir, "resources");
            JavadocOptions options = null;
            File javadocOptions = new File(dir, "META-INF/maven/javadoc-options.xml");
            if (javadocOptions.exists()) {
                try (FileInputStream reader = new FileInputStream(javadocOptions);){
                    options = new JavadocOptionsXpp3Reader().read(reader);
                }
                catch (XmlPullParserException e) {
                    IOException error = new IOException("Failed to parse javadoc options: " + e.getMessage(), e);
                    throw error;
                }
            }
            arrayList.add(new JavadocBundle(options, resources));
        }
        return arrayList;
    }

    private Collection<Map.Entry<String, Path>> resolveFromArtifacts(SourceResolverConfig config, List<Artifact> artifacts) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<Artifact> toResolve = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            if (config.filter() != null && !new ArtifactIncludeFilterTransformer().transform(config.filter()).include(artifact)) continue;
            if (config.includeCompileSources()) {
                toResolve.add(this.createResourceArtifact(artifact, SOURCES_CLASSIFIER, config));
            }
            if (!config.includeTestSources()) continue;
            toResolve.add(this.createResourceArtifact(artifact, TEST_SOURCES_CLASSIFIER, config));
        }
        return this.resolveAndUnpack(toResolve, config, SOURCE_VALID_CLASSIFIERS, true);
    }

    private Artifact createResourceArtifact(Artifact artifact, String classifier, SourceResolverConfig config) {
        DefaultArtifact a = (DefaultArtifact)this.artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", classifier);
        a.setRepository(artifact.getRepository());
        return a;
    }

    private Collection<Map.Entry<String, Path>> resolveAndUnpack(List<Artifact> artifacts, SourceResolverConfig config, List<String> validClassifiers, boolean propagateErrors) throws ArtifactResolutionException, ArtifactNotFoundException {
        LinkedHashSet<Artifact> artifactSet = new LinkedHashSet<Artifact>(artifacts);
        AndArtifactFilter filter = config.filter() != null ? new ArtifactIncludeFilterTransformer().transform(config.filter()) : null;
        ArrayList<Map.Entry<String, Path>> result = new ArrayList<Map.Entry<String, Path>>(artifacts.size());
        for (Artifact a : artifactSet) {
            Artifact resolvedArtifact;
            if (!validClassifiers.contains(a.getClassifier()) || filter != null && !filter.include(a)) continue;
            try {
                resolvedArtifact = this.resolver.resolveArtifact(config.getBuildingRequest(), a).getArtifact();
            }
            catch (ArtifactResolverException e1) {
                continue;
            }
            File d = new File(config.outputBasedir(), a.getArtifactId() + "-" + a.getVersion() + "-" + a.getClassifier());
            if (!d.exists()) {
                d.mkdirs();
            }
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(a.getType());
                unArchiver.setDestDirectory(d);
                unArchiver.setSourceFile(resolvedArtifact.getFile());
                unArchiver.extract();
                result.add(new AbstractMap.SimpleEntry<String, Path>(ResourceResolver.key(a.getGroupId(), a.getArtifactId()), d.toPath().toAbsolutePath()));
            }
            catch (NoSuchArchiverException e) {
                if (!propagateErrors) continue;
                throw new ArtifactResolutionException("Failed to retrieve valid un-archiver component: " + a.getType(), a, (Throwable)e);
            }
            catch (ArchiverException e) {
                if (!propagateErrors) continue;
                throw new ArtifactResolutionException("Failed to unpack: " + a.getId(), a, (Throwable)e);
            }
        }
        return result;
    }

    private static Collection<Path> resolveFromProject(SourceResolverConfig config, MavenProject reactorProject, Artifact artifact) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (config.filter() == null || new ArtifactIncludeFilterTransformer().transform(config.filter()).include(artifact)) {
            List srcRoots;
            if (config.includeCompileSources()) {
                srcRoots = reactorProject.getCompileSourceRoots();
                dirs.addAll(srcRoots);
            }
            if (config.includeTestSources()) {
                srcRoots = reactorProject.getTestCompileSourceRoots();
                dirs.addAll(srcRoots);
            }
        }
        return JavadocUtil.pruneDirs(reactorProject, dirs);
    }

    private static String key(String gid, String aid) {
        return gid + ":" + aid;
    }
}

