/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.jxr.AbstractJxrReport;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="jxr")
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JxrReport
extends AbstractJxrReport {
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true, readonly=true)
    private List<String> sourceDirs;
    @Parameter
    private String sourcePath;
    @Parameter
    private File javadocLocation;

    @Override
    protected File getPluginReportOutputDirectory() {
        return new File(this.getReportOutputDirectory(), "xref");
    }

    @Override
    protected List<String> getSourceRoots() {
        String[] sourcePathArray;
        if (this.sourcePath != null && (sourcePathArray = this.sourcePath.split(";")).length > 0) {
            return Arrays.asList(sourcePathArray);
        }
        ArrayList<String> l = new ArrayList<String>();
        if (!"pom".equals(this.getProject().getPackaging().toLowerCase(Locale.ENGLISH))) {
            l.addAll(this.sourceDirs);
        }
        if (this.getProject().getExecutionProject() != null && !"pom".equals(this.getProject().getExecutionProject().getPackaging().toLowerCase(Locale.ENGLISH))) {
            l.addAll(this.getProject().getExecutionProject().getCompileSourceRoots());
        }
        return l;
    }

    @Override
    protected List<String> getSourceRoots(MavenProject project) {
        ArrayList<String> l = new ArrayList<String>();
        if (!"pom".equals(project.getPackaging().toLowerCase(Locale.ENGLISH))) {
            l.addAll(project.getCompileSourceRoots());
        }
        if (project.getExecutionProject() != null && !"pom".equals(project.getExecutionProject().getPackaging().toLowerCase(Locale.ENGLISH))) {
            l.addAll(project.getExecutionProject().getCompileSourceRoots());
        }
        return l;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.main.name");
    }

    public String getOutputName() {
        return "xref/index";
    }

    @Override
    protected File getJavadocLocation() {
        return this.javadocLocation != null ? this.javadocLocation : new File(this.getReportOutputDirectory(), "apidocs");
    }
}

