/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.plexus.util.StringUtils;

public class CimReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$CimReport;

    public String getName(Locale locale) {
        return CimReport.getBundle(locale).getString("report.cim.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return CimReport.getBundle(locale).getString("report.cim.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        CimRenderer r = new CimRenderer(this.getSink(), this.getProject().getModel(), locale);
        r.render();
    }

    public String getOutputName() {
        return "integration";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$CimReport == null ? (class$org$apache$maven$report$projectinfo$CimReport = CimReport.class$("org.apache.maven.report.projectinfo.CimReport")) : class$org$apache$maven$report$projectinfo$CimReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CimRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private Locale locale;

        public CimRenderer(Sink sink, Model model, Locale locale) {
            super(sink);
            this.model = model;
            this.locale = locale;
        }

        public String getTitle() {
            return CimReport.getBundle(this.locale).getString("report.cim.title");
        }

        public void renderBody() {
            CiManagement cim = this.model.getCiManagement();
            if (cim == null) {
                this.startSection(this.getTitle());
                this.paragraph(CimReport.getBundle(this.locale).getString("report.cim.nocim"));
                this.endSection();
                return;
            }
            String system = cim.getSystem();
            String url = cim.getUrl();
            List notifiers = cim.getNotifiers();
            this.startSection(CimReport.getBundle(this.locale).getString("report.cim.overview.title"));
            if (this.isCimSystem(system, "continuum")) {
                this.linkPatternedText(CimReport.getBundle(this.locale).getString("report.cim.continuum.intro"));
            } else if (this.isCimSystem(system, "bugzilla")) {
                this.linkPatternedText(CimReport.getBundle(this.locale).getString("report.cim.bugzilla.intro"));
            } else {
                this.linkPatternedText(CimReport.getBundle(this.locale).getString("report.cim.general.intro"));
            }
            this.endSection();
            this.startSection(CimReport.getBundle(this.locale).getString("report.cim.access"));
            if (!StringUtils.isEmpty((String)url)) {
                this.paragraph(CimReport.getBundle(this.locale).getString("report.cim.url"));
                this.verbatimLink(url, url);
            } else {
                this.paragraph(CimReport.getBundle(this.locale).getString("report.cim.nourl"));
            }
            this.endSection();
            this.startSection(CimReport.getBundle(this.locale).getString("report.cim.notifiers.title"));
            if (notifiers == null || notifiers.isEmpty()) {
                this.paragraph(CimReport.getBundle(this.locale).getString("report.cim.notifiers.nolist"));
            } else {
                this.startTable();
                this.tableCaption(CimReport.getBundle(this.locale).getString("report.cim.notifiers.intro"));
                String type = CimReport.getBundle(this.locale).getString("report.cim.notifiers.column.type");
                String address = CimReport.getBundle(this.locale).getString("report.cim.notifiers.column.address");
                String configuration = CimReport.getBundle(this.locale).getString("report.cim.notifiers.column.configuration");
                this.tableHeader(new String[]{type, address, configuration});
                Iterator i = notifiers.iterator();
                while (i.hasNext()) {
                    Notifier notifier = (Notifier)i.next();
                    this.tableRow(new String[]{notifier.getType(), AbstractMavenReportRenderer.createLinkPatternedText((String)notifier.getAddress(), (String)notifier.getAddress()), AbstractMavenReportRenderer.propertiesToString((Properties)notifier.getConfiguration())});
                }
                this.endTable();
            }
            this.endSection();
        }

        private boolean isCimSystem(String connection, String cim) {
            if (StringUtils.isEmpty((String)connection)) {
                return false;
            }
            if (StringUtils.isEmpty((String)cim)) {
                return false;
            }
            return connection.toLowerCase().startsWith(cim.toLowerCase());
        }
    }
}

