/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class DependenciesReport
extends AbstractMavenReport {
    private String outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    static /* synthetic */ Class class$org$apache$maven$report$projectinfo$DependenciesReport;

    public String getName(Locale locale) {
        return DependenciesReport.getBundle(locale).getString("report.dependencies.name");
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getDescription(Locale locale) {
        return DependenciesReport.getBundle(locale).getString("report.dependencies.description");
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void executeReport(Locale locale) {
        DependenciesRenderer r = new DependenciesRenderer(this.getSink(), this.getProject(), locale, this.mavenProjectBuilder, this.artifactFactory, this.localRepository);
        r.render();
    }

    public String getOutputName() {
        return "dependencies";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("project-info-report", locale, (class$org$apache$maven$report$projectinfo$DependenciesReport == null ? (class$org$apache$maven$report$projectinfo$DependenciesReport = DependenciesReport.class$("org.apache.maven.report.projectinfo.DependenciesReport")) : class$org$apache$maven$report$projectinfo$DependenciesReport).getClassLoader());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DependenciesRenderer
    extends AbstractMavenReportRenderer {
        private MavenProject project;
        private Locale locale;
        private ArtifactFactory artifactFactory;
        private MavenProjectBuilder mavenProjectBuilder;
        private ArtifactRepository localRepository;

        public DependenciesRenderer(Sink sink, MavenProject project, Locale locale, MavenProjectBuilder mavenProjectBuilder, ArtifactFactory artifactFactory, ArtifactRepository localRepository) {
            super(sink);
            this.project = project;
            this.locale = locale;
            this.mavenProjectBuilder = mavenProjectBuilder;
            this.artifactFactory = artifactFactory;
            this.localRepository = localRepository;
        }

        public String getTitle() {
            return DependenciesReport.getBundle(this.locale).getString("report.dependencies.title");
        }

        public void renderBody() {
            Set dependencies = this.project.getDependencyArtifacts();
            if (dependencies == null || dependencies.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(DependenciesReport.getBundle(this.locale).getString("report.dependencies.nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.startTable();
            this.tableCaption(DependenciesReport.getBundle(this.locale).getString("report.dependencies.intro"));
            String groupId = DependenciesReport.getBundle(this.locale).getString("report.dependencies.column.groupId");
            String artifactId = DependenciesReport.getBundle(this.locale).getString("report.dependencies.column.artifactId");
            String version = DependenciesReport.getBundle(this.locale).getString("report.dependencies.column.version");
            String description = DependenciesReport.getBundle(this.locale).getString("report.dependencies.column.description");
            String url = DependenciesReport.getBundle(this.locale).getString("report.dependencies.column.url");
            this.tableHeader(new String[]{groupId, artifactId, version, description, url});
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                MavenProject artifactProject;
                Artifact artifact = (Artifact)i.next();
                try {
                    artifactProject = this.getMavenProjectFromRepository(artifact, this.localRepository);
                }
                catch (ProjectBuildingException e) {
                    throw new IllegalArgumentException("Can't find a valid Maven project in the repository for the artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + "].");
                }
                this.tableRow(new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifactProject.getDescription(), AbstractMavenReportRenderer.createLinkPatternedText((String)artifactProject.getUrl(), (String)artifactProject.getUrl())});
            }
            this.endTable();
            this.endSection();
            Set artifacts = this.getTransitiveDependencies(this.project);
            this.startSection(DependenciesReport.getBundle(this.locale).getString("report.transitivedependencies.title"));
            if (artifacts.isEmpty()) {
                this.paragraph(DependenciesReport.getBundle(this.locale).getString("report.transitivedependencies.nolist"));
            } else {
                this.startTable();
                this.tableCaption(DependenciesReport.getBundle(this.locale).getString("report.transitivedependencies.intro"));
                this.tableHeader(new String[]{groupId, artifactId, version, description, url});
                Iterator i2 = artifacts.iterator();
                while (i2.hasNext()) {
                    MavenProject artifactProject;
                    Artifact artifact = (Artifact)i2.next();
                    try {
                        artifactProject = this.getMavenProjectFromRepository(artifact, this.localRepository);
                    }
                    catch (ProjectBuildingException e) {
                        throw new IllegalArgumentException("Can't find a valid Maven project in the repository for the artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + "].");
                    }
                    this.tableRow(new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifactProject.getDescription(), AbstractMavenReportRenderer.createLinkPatternedText((String)artifactProject.getUrl(), (String)artifactProject.getUrl())});
                }
                this.endTable();
            }
            this.endSection();
        }

        private Set getTransitiveDependencies(MavenProject project) {
            HashSet<Artifact> transitiveDependencies = new HashSet<Artifact>();
            Set dependencies = project.getDependencyArtifacts();
            Set artifacts = project.getArtifacts();
            if (dependencies == null || artifacts == null) {
                return transitiveDependencies;
            }
            Iterator j = artifacts.iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                if (dependencies.contains(artifact)) continue;
                transitiveDependencies.add(artifact);
            }
            return transitiveDependencies;
        }

        private MavenProject getMavenProjectFromRepository(Artifact artifact, ArtifactRepository localRepository) throws ProjectBuildingException {
            Artifact projectArtifact = artifact;
            boolean allowStubModel = false;
            if (!"pom".equals(artifact.getType())) {
                projectArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
                allowStubModel = true;
            }
            return this.mavenProjectBuilder.buildFromRepository(projectArtifact, this.project.getRemoteArtifactRepositories(), localRepository, allowStubModel);
        }
    }
}

