/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies.renderer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.HtmlTools;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.report.projectinfo.dependencies.Dependencies;
import org.apache.maven.report.projectinfo.dependencies.DependenciesReportConfiguration;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.jar.JarData;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesRenderer
extends AbstractProjectInfoRenderer {
    private static final String IMG_INFO_URL = "./images/icon_info_sml.gif";
    private static final String IMG_CLOSE_URL = "./images/close.gif";
    protected static final DecimalFormat DEFAULT_DECIMAL_FORMAT = new DecimalFormat("###0");
    private static final Set<String> JAR_SUBTYPE;
    private final DependencyNode dependencyNode;
    private final Dependencies dependencies;
    private final DependenciesReportConfiguration configuration;
    private final Log log;
    private final Settings settings;
    private final RepositoryUtils repoUtils;
    private final DecimalFormat fileLengthDecimalFormat;
    private int section;
    private int idCounter = 0;
    private Map<String, Object> licenseMap = new HashMap<String, Object>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object put(String key, Object value) {
            TreeSet<Object> valueList = (TreeSet<Object>)this.get(key);
            if (valueList == null) {
                valueList = new TreeSet<Object>();
            }
            valueList.add(value);
            return super.put(key, valueList);
        }
    };
    private final ArtifactFactory artifactFactory;
    private final MavenProjectBuilder mavenProjectBuilder;
    private final List<ArtifactRepository> remoteRepositories;
    private final ArtifactRepository localRepository;

    public DependenciesRenderer(Sink sink, Locale locale, I18N i18n, Log log, Settings settings, Dependencies dependencies, DependencyNode dependencyTreeNode, DependenciesReportConfiguration config, RepositoryUtils repoUtils, ArtifactFactory artifactFactory, MavenProjectBuilder mavenProjectBuilder, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) {
        super(sink, i18n, locale);
        this.log = log;
        this.settings = settings;
        this.dependencies = dependencies;
        this.dependencyNode = dependencyTreeNode;
        this.repoUtils = repoUtils;
        this.configuration = config;
        this.artifactFactory = artifactFactory;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.remoteRepositories = remoteRepositories;
        this.localRepository = localRepository;
        DEFAULT_DECIMAL_FORMAT.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        this.fileLengthDecimalFormat = new FileDecimalFormat(i18n, locale);
        this.fileLengthDecimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
    }

    @Override
    protected String getI18Nsection() {
        return "dependencies";
    }

    public void renderBody() {
        if (!this.dependencies.hasDependencies()) {
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("nolist"));
            this.endSection();
            return;
        }
        this.renderSectionProjectDependencies();
        this.renderSectionProjectTransitiveDependencies();
        this.renderSectionProjectDependencyGraph();
        this.renderSectionDependencyLicenseListing();
        if (this.configuration.getDependencyDetailsEnabled()) {
            this.renderSectionDependencyFileDetails();
        }
        if (this.configuration.getDependencyLocationsEnabled()) {
            this.renderSectionDependencyRepositoryLocations();
        }
    }

    protected void startSection(String name) {
        this.startSection(name, name);
    }

    protected void startSection(String anchor, String name) {
        ++this.section;
        this.sink.anchor(HtmlTools.encodeId((String)anchor));
        this.sink.anchor_();
        switch (this.section) {
            case 1: {
                this.sink.section1();
                this.sink.sectionTitle1();
                break;
            }
            case 2: {
                this.sink.section2();
                this.sink.sectionTitle2();
                break;
            }
            case 3: {
                this.sink.section3();
                this.sink.sectionTitle3();
                break;
            }
            case 4: {
                this.sink.section4();
                this.sink.sectionTitle4();
                break;
            }
            case 5: {
                this.sink.section5();
                this.sink.sectionTitle5();
                break;
            }
        }
        this.text(name);
        switch (this.section) {
            case 1: {
                this.sink.sectionTitle1_();
                break;
            }
            case 2: {
                this.sink.sectionTitle2_();
                break;
            }
            case 3: {
                this.sink.sectionTitle3_();
                break;
            }
            case 4: {
                this.sink.sectionTitle4_();
                break;
            }
            case 5: {
                this.sink.sectionTitle5_();
                break;
            }
        }
    }

    protected void endSection() {
        switch (this.section) {
            case 1: {
                this.sink.section1_();
                break;
            }
            case 2: {
                this.sink.section2_();
                break;
            }
            case 3: {
                this.sink.section3_();
                break;
            }
            case 4: {
                this.sink.section4_();
                break;
            }
            case 5: {
                this.sink.section5_();
                break;
            }
        }
        --this.section;
        if (this.section < 0) {
            throw new IllegalStateException("Too many closing sections");
        }
    }

    private String[] getDependencyTableHeader(boolean withClassifier, boolean withOptional) {
        String groupId = this.getI18nString("column.groupId");
        String artifactId = this.getI18nString("column.artifactId");
        String version = this.getI18nString("column.version");
        String classifier = this.getI18nString("column.classifier");
        String type = this.getI18nString("column.type");
        String license = this.getI18nString("column.license");
        String optional = this.getI18nString("column.optional");
        if (withClassifier) {
            if (withOptional) {
                return new String[]{groupId, artifactId, version, classifier, type, license, optional};
            }
            return new String[]{groupId, artifactId, version, classifier, type, license};
        }
        if (withOptional) {
            return new String[]{groupId, artifactId, version, type, license, optional};
        }
        return new String[]{groupId, artifactId, version, type, license};
    }

    private void renderSectionProjectDependencies() {
        this.startSection(this.getTitle());
        Map<String, List<Artifact>> dependenciesByScope = this.dependencies.getDependenciesByScope(false);
        this.renderDependenciesForAllScopes(dependenciesByScope, false);
        this.endSection();
    }

    private void renderDependenciesForAllScopes(Map<String, List<Artifact>> dependenciesByScope, boolean isTransitive) {
        this.renderDependenciesForScope("compile", dependenciesByScope.get("compile"), isTransitive);
        this.renderDependenciesForScope("runtime", dependenciesByScope.get("runtime"), isTransitive);
        this.renderDependenciesForScope("test", dependenciesByScope.get("test"), isTransitive);
        this.renderDependenciesForScope("provided", dependenciesByScope.get("provided"), isTransitive);
        this.renderDependenciesForScope("system", dependenciesByScope.get("system"), isTransitive);
    }

    private void renderSectionProjectTransitiveDependencies() {
        Map<String, List<Artifact>> dependenciesByScope = this.dependencies.getDependenciesByScope(true);
        this.startSection(this.getI18nString("transitive.title"));
        if (dependenciesByScope.values().isEmpty()) {
            this.paragraph(this.getI18nString("transitive.nolist"));
        } else {
            this.paragraph(this.getI18nString("transitive.intro"));
            this.renderDependenciesForAllScopes(dependenciesByScope, true);
        }
        this.endSection();
    }

    private void renderSectionProjectDependencyGraph() {
        this.startSection(this.getI18nString("graph.title"));
        this.renderSectionDependencyTree();
        this.endSection();
    }

    private void renderSectionDependencyTree() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("");
        pw.println("<script language=\"javascript\" type=\"text/javascript\">");
        pw.println("      function toggleDependencyDetails( divId, imgId )");
        pw.println("      {");
        pw.println("        var div = document.getElementById( divId );");
        pw.println("        var img = document.getElementById( imgId );");
        pw.println("        if( div.style.display == '' )");
        pw.println("        {");
        pw.println("          div.style.display = 'none';");
        pw.printf("          img.src='%s';%n", IMG_INFO_URL);
        pw.printf("          img.alt='%s';%n", this.getI18nString("graph.icon.information"));
        pw.println("        }");
        pw.println("        else");
        pw.println("        {");
        pw.println("          div.style.display = '';");
        pw.printf("          img.src='%s';%n", IMG_CLOSE_URL);
        pw.printf("          img.alt='%s';%n", this.getI18nString("graph.icon.close"));
        pw.println("        }");
        pw.println("      }");
        pw.println("</script>");
        this.sink.rawText(sw.toString());
        this.startSection(this.getI18nString("graph.tree.title"));
        this.sink.list();
        this.printDependencyListing(this.dependencyNode);
        this.sink.list_();
        this.endSection();
    }

    private void renderSectionDependencyFileDetails() {
        String[] tableHeaderTitles;
        String[] tableHeader;
        this.startSection(this.getI18nString("file.details.title"));
        List<Artifact> alldeps = this.dependencies.getAllDependencies();
        Collections.sort(alldeps, this.getArtifactComparator());
        this.resolveAtrifacts(alldeps);
        String filename = this.getI18nString("file.details.column.file");
        String size = this.getI18nString("file.details.column.size");
        String entries = this.getI18nString("file.details.column.entries");
        String classes = this.getI18nString("file.details.column.classes");
        String packages = this.getI18nString("file.details.column.packages");
        String javaVersion = this.getI18nString("file.details.column.javaVersion");
        String debugInformation = this.getI18nString("file.details.column.debuginformation");
        String debugInformationTitle = this.getI18nString("file.details.columntitle.debuginformation");
        String debugInformationCellYes = this.getI18nString("file.details.cell.debuginformation.yes");
        String debugInformationCellNo = this.getI18nString("file.details.cell.debuginformation.no");
        String sealed = this.getI18nString("file.details.column.sealed");
        String sealedCellYes = this.getI18nString("file.details.cell.sealed.yes");
        String sealedCellNo = this.getI18nString("file.details.cell.sealed.no");
        int[] justification = new int[]{1, 2, 2, 2, 2, 0, 0, 0};
        this.startTable(justification, false);
        TotalCell totaldeps = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        TotalCell totaldepsize = new TotalCell(this.fileLengthDecimalFormat);
        TotalCell totalentries = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        TotalCell totalclasses = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        TotalCell totalpackages = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        double highestJavaVersion = 0.0;
        TotalCell totalDebugInformation = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        TotalCell totalsealed = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        boolean hasSealed = this.hasSealed(alldeps);
        if (hasSealed) {
            tableHeader = new String[]{filename, size, entries, classes, packages, javaVersion, debugInformation, sealed};
            tableHeaderTitles = new String[]{null, null, null, null, null, null, debugInformationTitle, null};
        } else {
            tableHeader = new String[]{filename, size, entries, classes, packages, javaVersion, debugInformation};
            tableHeaderTitles = new String[]{null, null, null, null, null, null, debugInformationTitle};
        }
        this.tableHeader(tableHeader, tableHeaderTitles);
        for (Artifact artifact : alldeps) {
            if (artifact.getFile() == null) {
                this.log.warn((CharSequence)("Artifact " + artifact.getId() + " has no file" + " and won't be listed in dependency files details."));
                continue;
            }
            File artifactFile = this.dependencies.getFile(artifact);
            totaldeps.incrementTotal(artifact.getScope());
            totaldepsize.addTotal(artifactFile.length(), artifact.getScope());
            if (JAR_SUBTYPE.contains(artifact.getType().toLowerCase())) {
                try {
                    JarData jarDetails = this.dependencies.getJarDependencyDetails(artifact);
                    String debugInformationCellValue = debugInformationCellNo;
                    if (jarDetails.isDebugPresent()) {
                        debugInformationCellValue = debugInformationCellYes;
                        totalDebugInformation.incrementTotal(artifact.getScope());
                    }
                    totalentries.addTotal(jarDetails.getNumEntries(), artifact.getScope());
                    totalclasses.addTotal(jarDetails.getNumClasses(), artifact.getScope());
                    totalpackages.addTotal(jarDetails.getNumPackages(), artifact.getScope());
                    try {
                        if (jarDetails.getJdkRevision() != null) {
                            highestJavaVersion = Math.max(highestJavaVersion, Double.parseDouble(jarDetails.getJdkRevision()));
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    String sealedCellValue = sealedCellNo;
                    if (jarDetails.isSealed()) {
                        sealedCellValue = sealedCellYes;
                        totalsealed.incrementTotal(artifact.getScope());
                    }
                    String name = artifactFile.getName();
                    String fileLength = this.fileLengthDecimalFormat.format(artifactFile.length());
                    if (artifactFile.isDirectory()) {
                        File parent = artifactFile.getParentFile();
                        name = parent.getParentFile().getName() + '/' + parent.getName() + '/' + artifactFile.getName();
                        fileLength = "-";
                    }
                    this.tableRow(hasSealed, new String[]{name, fileLength, DEFAULT_DECIMAL_FORMAT.format(jarDetails.getNumEntries()), DEFAULT_DECIMAL_FORMAT.format(jarDetails.getNumClasses()), DEFAULT_DECIMAL_FORMAT.format(jarDetails.getNumPackages()), jarDetails.getJdkRevision(), debugInformationCellValue, sealedCellValue});
                }
                catch (IOException e) {
                    this.createExceptionInfoTableRow(artifact, artifactFile, e, hasSealed);
                }
                continue;
            }
            this.tableRow(hasSealed, new String[]{artifactFile.getName(), this.fileLengthDecimalFormat.format(artifactFile.length()), "", "", "", "", "", ""});
        }
        tableHeader[0] = this.getI18nString("file.details.total");
        this.tableHeader(tableHeader);
        justification[0] = 2;
        justification[6] = 2;
        for (int i = -1; i < 5; ++i) {
            if (totaldeps.getTotal(i) <= 0L) continue;
            this.tableRow(hasSealed, new String[]{totaldeps.getTotalString(i), totaldepsize.getTotalString(i), totalentries.getTotalString(i), totalclasses.getTotalString(i), totalpackages.getTotalString(i), i < 0 ? String.valueOf(highestJavaVersion) : "", totalDebugInformation.getTotalString(i), totalsealed.getTotalString(i)});
        }
        this.endTable();
        this.endSection();
    }

    private void tableHeader(String[] content, String[] titles) {
        this.sink.tableRow();
        if (content != null) {
            if (titles != null && content.length != titles.length) {
                throw new IllegalArgumentException("Length of title array must equal the length of the content array");
            }
            for (int i = 0; i < content.length; ++i) {
                if (titles != null) {
                    this.tableHeaderCell(content[i], titles[i]);
                    continue;
                }
                this.tableHeaderCell(content[i]);
            }
        }
        this.sink.tableRow_();
    }

    private void tableHeaderCell(String text, String title) {
        if (title != null) {
            SinkEventAttributeSet attributes = new SinkEventAttributeSet(new String[]{"title", title});
            this.sink.tableHeaderCell((SinkEventAttributes)attributes);
        } else {
            this.sink.tableHeaderCell();
        }
        this.text(text);
        this.sink.tableHeaderCell_();
    }

    private void tableRow(boolean fullRow, String[] content) {
        this.sink.tableRow();
        int count = fullRow ? content.length : content.length - 1;
        for (int i = 0; i < count; ++i) {
            this.tableCell(content[i]);
        }
        this.sink.tableRow_();
    }

    private void createExceptionInfoTableRow(Artifact artifact, File artifactFile, Exception e, boolean hasSealed) {
        this.tableRow(hasSealed, new String[]{artifact.getId(), artifactFile.getAbsolutePath(), e.getMessage(), "", "", "", "", ""});
    }

    private void populateRepositoryMap(Map<String, ArtifactRepository> repos, List<ArtifactRepository> rowRepos) {
        for (ArtifactRepository repo : rowRepos) {
            repos.put(repo.getId(), repo);
        }
    }

    private void blacklistRepositoryMap(Map<String, ArtifactRepository> repos, List<String> repoUrlBlackListed) {
        for (ArtifactRepository repo : repos.values()) {
            if (repo.isBlacklisted()) {
                repoUrlBlackListed.add(repo.getUrl());
                continue;
            }
            if (repoUrlBlackListed.contains(repo.getUrl())) {
                repo.setBlacklisted(true);
                continue;
            }
            try {
                URL repoUrl = new URL(repo.getUrl());
                if (ProjectInfoReportUtils.getContent(repoUrl, this.settings) != null) continue;
                this.log.warn((CharSequence)("The repository url '" + repoUrl + "' has no stream - Repository '" + repo.getId() + "' will be blacklisted."));
                repo.setBlacklisted(true);
                repoUrlBlackListed.add(repo.getUrl());
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("The repository url '" + repo.getUrl() + "' is invalid - Repository '" + repo.getId() + "' will be blacklisted."));
                repo.setBlacklisted(true);
                repoUrlBlackListed.add(repo.getUrl());
            }
        }
    }

    private void renderSectionDependencyRepositoryLocations() {
        this.startSection(this.getI18nString("repo.locations.title"));
        List<Artifact> alldeps = this.dependencies.getAllDependencies();
        Collections.sort(alldeps, this.getArtifactComparator());
        HashMap<String, ArtifactRepository> repoMap = new HashMap<String, ArtifactRepository>();
        this.populateRepositoryMap(repoMap, this.repoUtils.getRemoteArtifactRepositories());
        for (Artifact artifact : alldeps) {
            try {
                MavenProject artifactProject = this.repoUtils.getMavenProjectFromRepository(artifact);
                this.populateRepositoryMap(repoMap, artifactProject.getRemoteArtifactRepositories());
            }
            catch (ProjectBuildingException e) {
                this.log.warn((CharSequence)("Unable to create Maven project from repository for artifact " + artifact.getId()), (Throwable)e);
            }
        }
        ArrayList<String> repoUrlBlackListed = new ArrayList<String>();
        this.blacklistRepositoryMap(repoMap, repoUrlBlackListed);
        this.printRepositories(repoMap, repoUrlBlackListed);
        this.printArtifactsLocations(repoMap, repoUrlBlackListed, alldeps);
        this.endSection();
    }

    private void renderSectionDependencyLicenseListing() {
        this.startSection(this.getI18nString("graph.tables.licenses"));
        this.printGroupedLicenses();
        this.endSection();
    }

    private void renderDependenciesForScope(String scope, List<Artifact> artifacts, boolean isTransitive) {
        if (artifacts != null) {
            boolean withClassifier = this.hasClassifier(artifacts);
            boolean withOptional = this.hasOptional(artifacts);
            String[] tableHeader = this.getDependencyTableHeader(withClassifier, withOptional);
            Collections.sort(artifacts, this.getArtifactComparator());
            String anchorByScope = isTransitive ? this.getI18nString("transitive.title") + "_" + scope : this.getI18nString("title") + "_" + scope;
            this.startSection(anchorByScope, scope);
            this.paragraph(this.getI18nString("intro." + scope));
            this.startTable();
            this.tableHeader(tableHeader);
            for (Artifact artifact : artifacts) {
                this.renderArtifactRow(artifact, withClassifier, withOptional);
            }
            this.endTable();
            this.endSection();
        }
    }

    private Comparator<Artifact> getArtifactComparator() {
        return new Comparator<Artifact>(){

            @Override
            public int compare(Artifact a1, Artifact a2) {
                if (a1.isOptional() && !a2.isOptional()) {
                    return 1;
                }
                if (!a1.isOptional() && a2.isOptional()) {
                    return -1;
                }
                return a1.compareTo((Object)a2);
            }
        };
    }

    private void renderArtifactRow(Artifact artifact, boolean withClassifier, boolean withOptional) {
        String isOptional = artifact.isOptional() ? this.getI18nString("column.isOptional") : this.getI18nString("column.isNotOptional");
        String url = ProjectInfoReportUtils.getArtifactUrl(this.artifactFactory, artifact, this.mavenProjectBuilder, this.remoteRepositories, this.localRepository);
        String artifactIdCell = ProjectInfoReportUtils.getArtifactIdCell(artifact.getArtifactId(), url);
        StringBuilder sb = new StringBuilder();
        try {
            MavenProject artifactProject = this.repoUtils.getMavenProjectFromRepository(artifact);
            List licenses = artifactProject.getLicenses();
            for (License license : licenses) {
                sb.append(ProjectInfoReportUtils.getArtifactIdCell(license.getName(), license.getUrl()));
            }
        }
        catch (ProjectBuildingException e) {
            this.log.warn((CharSequence)"Unable to create Maven project from repository.", (Throwable)e);
        }
        String[] content = withClassifier ? new String[]{artifact.getGroupId(), artifactIdCell, artifact.getVersion(), artifact.getClassifier(), artifact.getType(), sb.toString(), isOptional} : new String[]{artifact.getGroupId(), artifactIdCell, artifact.getVersion(), artifact.getType(), sb.toString(), isOptional};
        this.tableRow(withOptional, content);
    }

    private void printDependencyListing(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String id = artifact.getId();
        String dependencyDetailId = "_dep" + this.idCounter++;
        String imgId = "_img" + this.idCounter++;
        this.sink.listItem();
        this.sink.text(id + (StringUtils.isNotEmpty((String)artifact.getScope()) ? " (" + artifact.getScope() + ") " : " "));
        String javascript = String.format("<img id=\"%s\" src=\"%s\" alt=\"%s\" onclick=\"toggleDependencyDetails( '%s', '%s' );\" style=\"cursor: pointer; vertical-align: text-bottom;\"></img>", imgId, IMG_INFO_URL, this.getI18nString("graph.icon.information"), dependencyDetailId, imgId);
        this.sink.rawText(javascript);
        this.printDescriptionsAndURLs(node, dependencyDetailId);
        if (!node.getChildren().isEmpty()) {
            boolean toBeIncluded = false;
            ArrayList<DependencyNode> subList = new ArrayList<DependencyNode>();
            for (DependencyNode dep : node.getChildren()) {
                if (!this.dependencies.getAllDependencies().contains(dep.getArtifact())) continue;
                subList.add(dep);
                toBeIncluded = true;
            }
            if (toBeIncluded) {
                this.sink.list();
                for (DependencyNode dep : subList) {
                    this.printDependencyListing(dep);
                }
                this.sink.list_();
            }
        }
        this.sink.listItem_();
    }

    private void printDescriptionsAndURLs(DependencyNode node, String uid) {
        Artifact artifact = node.getArtifact();
        String id = artifact.getId();
        String unknownLicenseMessage = this.getI18nString("graph.tables.unknown");
        this.sink.rawText("<div id=\"" + uid + "\" style=\"display:none\">");
        this.sink.table();
        if (!"system".equals(artifact.getScope())) {
            try {
                MavenProject artifactProject = this.repoUtils.getMavenProjectFromRepository(artifact);
                String artifactDescription = artifactProject.getDescription();
                String artifactUrl = artifactProject.getUrl();
                String artifactName = artifactProject.getName();
                List licenses = artifactProject.getLicenses();
                this.sink.tableRow();
                this.sink.tableHeaderCell();
                this.sink.text(artifactName);
                this.sink.tableHeaderCell_();
                this.sink.tableRow_();
                this.sink.tableRow();
                this.sink.tableCell();
                this.sink.paragraph();
                this.sink.bold();
                this.sink.text(this.getI18nString("column.description") + ": ");
                this.sink.bold_();
                if (StringUtils.isNotEmpty((String)artifactDescription)) {
                    this.sink.text(artifactDescription);
                } else {
                    this.sink.text(this.getI18nString("index", "nodescription"));
                }
                this.sink.paragraph_();
                if (StringUtils.isNotEmpty((String)artifactUrl)) {
                    this.sink.paragraph();
                    this.sink.bold();
                    this.sink.text(this.getI18nString("column.url") + ": ");
                    this.sink.bold_();
                    if (ProjectInfoReportUtils.isArtifactUrlValid(artifactUrl)) {
                        this.sink.link(artifactUrl);
                        this.sink.text(artifactUrl);
                        this.sink.link_();
                    } else {
                        this.sink.text(artifactUrl);
                    }
                    this.sink.paragraph_();
                }
                this.sink.paragraph();
                this.sink.bold();
                this.sink.text(this.getI18nString("license", "title") + ": ");
                this.sink.bold_();
                if (!licenses.isEmpty()) {
                    Iterator it = licenses.iterator();
                    while (it.hasNext()) {
                        String licenseUrl;
                        License license = (License)it.next();
                        String licenseName = license.getName();
                        if (StringUtils.isEmpty((String)licenseName)) {
                            licenseName = this.getI18nString("unnamed");
                        }
                        if ((licenseUrl = license.getUrl()) != null) {
                            this.sink.link(licenseUrl);
                        }
                        this.sink.text(licenseName);
                        if (licenseUrl != null) {
                            this.sink.link_();
                        }
                        if (it.hasNext()) {
                            this.sink.text(", ");
                        }
                        this.licenseMap.put(licenseName, artifactName);
                    }
                } else {
                    this.sink.text(this.getI18nString("license", "nolicense"));
                    this.licenseMap.put(unknownLicenseMessage, artifactName);
                }
                this.sink.paragraph_();
            }
            catch (ProjectBuildingException e) {
                this.log.warn((CharSequence)("Unable to create Maven project from repository for artifact " + artifact.getId()), (Throwable)e);
            }
        } else {
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.text(id);
            this.sink.tableHeaderCell_();
            this.sink.tableRow_();
            this.sink.tableRow();
            this.sink.tableCell();
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(this.getI18nString("column.description") + ": ");
            this.sink.bold_();
            this.sink.text(this.getI18nString("index", "nodescription"));
            this.sink.paragraph_();
            if (artifact.getFile() != null) {
                this.sink.paragraph();
                this.sink.bold();
                this.sink.text(this.getI18nString("column.url") + ": ");
                this.sink.bold_();
                this.sink.text(artifact.getFile().getAbsolutePath());
                this.sink.paragraph_();
            }
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.rawText("</div>");
    }

    private void printGroupedLicenses() {
        for (Map.Entry<String, Object> entry : this.licenseMap.entrySet()) {
            String licenseName = entry.getKey();
            if (StringUtils.isEmpty((String)licenseName)) {
                licenseName = this.getI18nString("unnamed");
            }
            this.sink.paragraph();
            this.sink.bold();
            this.sink.text(licenseName);
            this.sink.text(": ");
            this.sink.bold_();
            SortedSet projects = (SortedSet)entry.getValue();
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                String projectName = (String)iterator.next();
                this.sink.text(projectName);
                if (!iterator.hasNext()) continue;
                this.sink.text(", ");
            }
            this.sink.paragraph_();
        }
    }

    private void printRepositories(Map<String, ArtifactRepository> repoMap, List<String> repoUrlBlackListed) {
        int[] justificationRepo;
        String[] tableHeader;
        String repoid = this.getI18nString("repo.locations.column.repoid");
        String url = this.getI18nString("repo.locations.column.url");
        String release = this.getI18nString("repo.locations.column.release");
        String snapshot = this.getI18nString("repo.locations.column.snapshot");
        String blacklisted = this.getI18nString("repo.locations.column.blacklisted");
        String releaseEnabled = this.getI18nString("repo.locations.cell.release.enabled");
        String releaseDisabled = this.getI18nString("repo.locations.cell.release.disabled");
        String snapshotEnabled = this.getI18nString("repo.locations.cell.snapshot.enabled");
        String snapshotDisabled = this.getI18nString("repo.locations.cell.snapshot.disabled");
        String blacklistedEnabled = this.getI18nString("repo.locations.cell.blacklisted.enabled");
        String blacklistedDisabled = this.getI18nString("repo.locations.cell.blacklisted.disabled");
        if (repoUrlBlackListed.isEmpty()) {
            tableHeader = new String[]{repoid, url, release, snapshot};
            justificationRepo = new int[]{1, 1, 0, 0};
        } else {
            tableHeader = new String[]{repoid, url, release, snapshot, blacklisted};
            justificationRepo = new int[]{1, 1, 0, 0, 0};
        }
        this.startTable(justificationRepo, false);
        this.tableHeader(tableHeader);
        for (ArtifactRepository repo : repoMap.values()) {
            List<ArtifactRepository> mirroredRepos = this.getMirroredRepositories(repo);
            this.sink.tableRow();
            this.sink.tableCell();
            boolean addLineBreak = false;
            for (ArtifactRepository r : mirroredRepos) {
                if (addLineBreak) {
                    this.sink.lineBreak();
                }
                addLineBreak = true;
                this.sink.text(r.getId());
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            addLineBreak = false;
            for (ArtifactRepository r : mirroredRepos) {
                if (addLineBreak) {
                    this.sink.lineBreak();
                }
                addLineBreak = true;
                if (repo.isBlacklisted()) {
                    this.sink.text(r.getUrl());
                    continue;
                }
                this.sink.link(r.getUrl());
                this.sink.text(r.getUrl());
                this.sink.link_();
            }
            this.sink.tableCell_();
            ArtifactRepositoryPolicy releasePolicy = repo.getReleases();
            this.tableCell(releasePolicy.isEnabled() ? releaseEnabled : releaseDisabled);
            ArtifactRepositoryPolicy snapshotPolicy = repo.getSnapshots();
            this.tableCell(snapshotPolicy.isEnabled() ? snapshotEnabled : snapshotDisabled);
            if (!repoUrlBlackListed.isEmpty()) {
                this.tableCell(repoUrlBlackListed.contains(repo.getUrl()) ? blacklistedEnabled : blacklistedDisabled);
            }
            this.sink.tableRow_();
        }
        this.endTable();
    }

    private void resolveAtrifacts(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() != null || "system".equals(artifact.getScope())) continue;
            try {
                this.repoUtils.resolve(artifact);
            }
            catch (ArtifactResolutionException e) {
                this.log.error((CharSequence)("Artifact " + artifact.getId() + " can't be resolved."), (Throwable)e);
                continue;
            }
            catch (ArtifactNotFoundException e) {
                if (this.dependencies.getProject().getGroupId().equals(artifact.getGroupId()) && this.dependencies.getProject().getArtifactId().equals(artifact.getArtifactId()) && this.dependencies.getProject().getVersion().equals(artifact.getVersion())) {
                    this.log.warn((CharSequence)"The artifact of this project has never been deployed.");
                    continue;
                }
                this.log.error((CharSequence)("Artifact " + artifact.getId() + " not found."), (Throwable)e);
                continue;
            }
            if (artifact.getFile() != null) continue;
            this.log.error((CharSequence)("Artifact " + artifact.getId() + " has no file, even after resolution."));
        }
    }

    private Object invoke(Object object, String method) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
    }

    private List<ArtifactRepository> getMirroredRepositories(ArtifactRepository repo) {
        try {
            List mirroredRepos = (List)this.invoke(repo, "getMirroredRepositories");
            if (mirroredRepos != null && !mirroredRepos.isEmpty()) {
                return mirroredRepos;
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Collections.singletonList(repo);
    }

    private void printArtifactsLocations(Map<String, ArtifactRepository> repoMap, List<String> repoUrlBlackListed, List<Artifact> alldeps) {
        String artifact = this.getI18nString("repo.locations.column.artifact");
        this.sink.paragraph();
        this.sink.text(this.getI18nString("repo.locations.artifact.breakdown"));
        this.sink.paragraph_();
        ArrayList<String> repoIdList = new ArrayList<String>();
        for (Map.Entry<String, ArtifactRepository> entry : repoMap.entrySet()) {
            String repokey = entry.getKey();
            ArtifactRepository repo = entry.getValue();
            if (repo.isBlacklisted() || repoUrlBlackListed.contains(repo.getUrl())) continue;
            repoIdList.add(repokey);
        }
        String[] tableHeader = new String[repoIdList.size() + 1];
        int[] justificationRepo = new int[repoIdList.size() + 1];
        tableHeader[0] = artifact;
        justificationRepo[0] = 1;
        int idnum = 1;
        Iterator i$ = repoIdList.iterator();
        while (i$.hasNext()) {
            String id;
            tableHeader[idnum] = id = (String)i$.next();
            justificationRepo[idnum] = 0;
            ++idnum;
        }
        HashMap<String, Integer> totalByRepo = new HashMap<String, Integer>();
        TotalCell totaldeps = new TotalCell(DEFAULT_DECIMAL_FORMAT);
        this.startTable(justificationRepo, false);
        this.tableHeader(tableHeader);
        for (Artifact dependency : alldeps) {
            totaldeps.incrementTotal(dependency.getScope());
            this.sink.tableRow();
            this.tableCell(dependency.getId());
            if ("system".equals(dependency.getScope())) {
                for (String repoId : repoIdList) {
                    this.tableCell("-");
                }
            } else {
                for (String repokey : repoIdList) {
                    ArtifactRepository repo = repoMap.get(repokey);
                    String depUrl = this.repoUtils.getDependencyUrlFromRepository(dependency, repo);
                    Integer old = (Integer)totalByRepo.get(repokey);
                    if (old == null) {
                        old = 0;
                        totalByRepo.put(repokey, old);
                    }
                    boolean dependencyExists = false;
                    if (dependency.isSnapshot() && repo.getSnapshots().isEnabled() || !dependency.isSnapshot() && repo.getReleases().isEnabled()) {
                        dependencyExists = this.repoUtils.dependencyExistsInRepo(repo, dependency);
                    }
                    if (dependencyExists) {
                        this.sink.tableCell();
                        if (StringUtils.isNotEmpty((String)depUrl)) {
                            this.sink.link(depUrl);
                        } else {
                            this.sink.text(depUrl);
                        }
                        this.sink.figure();
                        this.sink.figureCaption();
                        this.sink.text("Found at " + repo.getUrl());
                        this.sink.figureCaption_();
                        this.sink.figureGraphics("images/icon_success_sml.gif");
                        this.sink.figure_();
                        this.sink.link_();
                        this.sink.tableCell_();
                        totalByRepo.put(repokey, old + 1);
                        continue;
                    }
                    this.tableCell("-");
                }
            }
            this.sink.tableRow_();
        }
        tableHeader[0] = this.getI18nString("file.details.total");
        this.tableHeader(tableHeader);
        String[] totalRow = new String[repoIdList.size() + 1];
        totalRow[0] = totaldeps.toString();
        idnum = 1;
        for (String repokey : repoIdList) {
            Integer deps = (Integer)totalByRepo.get(repokey);
            totalRow[idnum++] = deps != null ? deps.toString() : "0";
        }
        this.tableRow(totalRow);
        this.endTable();
    }

    private boolean hasClassifier(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!StringUtils.isNotEmpty((String)artifact.getClassifier())) continue;
            return true;
        }
        return false;
    }

    private boolean hasOptional(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isOptional()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSealed(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || !JAR_SUBTYPE.contains(artifact.getType().toLowerCase())) continue;
            try {
                JarData jarDetails = this.dependencies.getJarDependencyDetails(artifact);
                if (!jarDetails.isSealed()) continue;
                return true;
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Artifact " + artifact.getId() + " caused IOException: " + e.getMessage()), (Throwable)e);
            }
        }
        return false;
    }

    static {
        HashSet<String> jarSubtype = new HashSet<String>();
        jarSubtype.add("jar");
        jarSubtype.add("war");
        jarSubtype.add("ear");
        jarSubtype.add("sar");
        jarSubtype.add("rar");
        jarSubtype.add("par");
        jarSubtype.add("ejb");
        JAR_SUBTYPE = Collections.unmodifiableSet(jarSubtype);
    }

    static class TotalCell {
        static final int SCOPES_COUNT = 5;
        final DecimalFormat decimalFormat;
        long total = 0L;
        long totalCompileScope = 0L;
        long totalTestScope = 0L;
        long totalRuntimeScope = 0L;
        long totalProvidedScope = 0L;
        long totalSystemScope = 0L;

        TotalCell(DecimalFormat decimalFormat) {
            this.decimalFormat = decimalFormat;
        }

        void incrementTotal(String scope) {
            this.addTotal(1L, scope);
        }

        static String getScope(int index) {
            switch (index) {
                case 0: {
                    return "compile";
                }
                case 1: {
                    return "test";
                }
                case 2: {
                    return "runtime";
                }
                case 3: {
                    return "provided";
                }
                case 4: {
                    return "system";
                }
            }
            return null;
        }

        long getTotal(int index) {
            switch (index) {
                case 0: {
                    return this.totalCompileScope;
                }
                case 1: {
                    return this.totalTestScope;
                }
                case 2: {
                    return this.totalRuntimeScope;
                }
                case 3: {
                    return this.totalProvidedScope;
                }
                case 4: {
                    return this.totalSystemScope;
                }
            }
            return this.total;
        }

        String getTotalString(int index) {
            long totalString = this.getTotal(index);
            if (totalString <= 0L) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            if (index >= 0) {
                sb.append(TotalCell.getScope(index)).append(": ");
            }
            sb.append(this.decimalFormat.format(this.getTotal(index)));
            return sb.toString();
        }

        void addTotal(long add, String scope) {
            this.total += add;
            if ("compile".equals(scope)) {
                this.totalCompileScope += add;
            } else if ("test".equals(scope)) {
                this.totalTestScope += add;
            } else if ("runtime".equals(scope)) {
                this.totalRuntimeScope += add;
            } else if ("provided".equals(scope)) {
                this.totalProvidedScope += add;
            } else if ("system".equals(scope)) {
                this.totalSystemScope += add;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.decimalFormat.format(this.total));
            sb.append(" (");
            boolean needSeparator = false;
            for (int i = 0; i < 5; ++i) {
                if (this.getTotal(i) <= 0L) continue;
                if (needSeparator) {
                    sb.append(", ");
                }
                sb.append(this.getTotalString(i));
                needSeparator = true;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static class FileDecimalFormat
    extends DecimalFormat {
        private static final long serialVersionUID = 4062503546523610081L;
        private final I18N i18n;
        private final Locale locale;

        public FileDecimalFormat(I18N i18n, Locale locale) {
            super("###0.00");
            this.i18n = i18n;
            this.locale = locale;
        }

        public StringBuffer format(long fs, StringBuffer result, FieldPosition fieldPosition) {
            if (fs > 1000000000L) {
                result = super.format((double)((float)fs / 1.0E9f), result, fieldPosition);
                result.append(" ").append(this.getString("report.dependencies.file.details.column.size.gb"));
                return result;
            }
            if (fs > 1000000L) {
                result = super.format((double)((float)fs / 1000000.0f), result, fieldPosition);
                result.append(" ").append(this.getString("report.dependencies.file.details.column.size.mb"));
                return result;
            }
            result = super.format((double)((float)fs / 1000.0f), result, fieldPosition);
            result.append(" ").append(this.getString("report.dependencies.file.details.column.size.kb"));
            return result;
        }

        private String getString(String key) {
            return this.i18n.getString("project-info-reports", this.locale, key);
        }
    }
}

