/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="mailing-lists")
public class MailingListsReport
extends AbstractProjectInfoReport {
    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getModel().getMailingLists());
        }
        return result;
    }

    public void executeReport(Locale locale) {
        MailingListsRenderer r = new MailingListsRenderer(this.getLog(), this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale);
        r.render();
    }

    public String getOutputName() {
        return "mailing-lists";
    }

    @Override
    protected String getI18Nsection() {
        return "mailing-lists";
    }

    protected static class MailingListsRenderer
    extends AbstractProjectInfoRenderer {
        private final Log log;
        private final Model model;

        MailingListsRenderer(Log log, Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
            this.log = log;
        }

        @Override
        protected String getI18Nsection() {
            return "mailing-lists";
        }

        protected void renderBody() {
            List mailingLists = this.model.getMailingLists();
            if (mailingLists == null || mailingLists.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            boolean otherArchives = false;
            for (MailingList m : mailingLists) {
                if (m.getOtherArchives() == null || m.getOtherArchives().isEmpty()) continue;
                otherArchives = true;
            }
            String name = this.getI18nString("column.name");
            String subscribe = this.getI18nString("column.subscribe");
            String unsubscribe = this.getI18nString("column.unsubscribe");
            String post = this.getI18nString("column.post");
            String archive = this.getI18nString("column.archive");
            String archivesOther = this.getI18nString("column.otherArchives");
            if (otherArchives) {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive, archivesOther});
            } else {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive});
            }
            for (MailingList mailingList : this.model.getMailingLists()) {
                ArrayList<String> textRow = new ArrayList<String>();
                if (StringUtils.isNotEmpty((String)mailingList.getName())) {
                    textRow.add(mailingList.getName());
                } else {
                    textRow.add("-");
                }
                if (StringUtils.isNotEmpty((String)mailingList.getSubscribe())) {
                    textRow.add(this.createURILinkPatternedText(subscribe, mailingList.getSubscribe(), null));
                } else {
                    textRow.add("-");
                }
                if (StringUtils.isNotEmpty((String)mailingList.getUnsubscribe())) {
                    textRow.add(this.createURILinkPatternedText(unsubscribe, mailingList.getUnsubscribe(), null));
                } else {
                    textRow.add("-");
                }
                if (StringUtils.isNotEmpty((String)mailingList.getPost())) {
                    textRow.add(this.createURILinkPatternedText(post, mailingList.getPost(), null));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getArchive() != null && !mailingList.getArchive().isEmpty()) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)ProjectInfoReportUtils.getArchiveServer(mailingList.getArchive()), (String)mailingList.getArchive()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getOtherArchives() != null && !mailingList.getOtherArchives().isEmpty()) {
                    Iterator it = mailingList.getOtherArchives().iterator();
                    String otherArchive = (String)it.next();
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)ProjectInfoReportUtils.getArchiveServer(otherArchive), (String)otherArchive));
                    this.tableRow(textRow.toArray(new String[textRow.size()]));
                    while (it.hasNext()) {
                        otherArchive = (String)it.next();
                        textRow = new ArrayList();
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(MailingListsRenderer.createLinkPatternedText((String)ProjectInfoReportUtils.getArchiveServer(otherArchive), (String)otherArchive));
                        this.tableRow(textRow.toArray(new String[textRow.size()]));
                    }
                    continue;
                }
                if (otherArchives) {
                    textRow.add(null);
                }
                this.tableRow(textRow.toArray(new String[textRow.size()]));
            }
            this.endTable();
            this.endSection();
        }

        private String createURILinkPatternedText(String text, String href, String defaultHref) {
            if (href == null || href.isEmpty()) {
                return MailingListsRenderer.createLinkPatternedText((String)text, (String)defaultHref);
            }
            try {
                URI hrefUri = URI.create(href);
                if (StringUtils.isNotEmpty((String)hrefUri.getScheme())) {
                    return MailingListsRenderer.createLinkPatternedText((String)text, (String)href);
                }
                return MailingListsRenderer.createLinkPatternedText((String)text, (String)("mailto:" + href));
            }
            catch (IllegalArgumentException e) {
                this.log.warn((CharSequence)("Invalid mailing list link provided '" + href + "': " + e.getMessage()));
                return href;
            }
        }
    }
}

