/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="diff", aggregator=true)
public class DiffMojo
extends AbstractScmMojo {
    @Parameter(property="startScmVersionType")
    private String startScmVersionType;
    @Parameter(property="startScmVersion")
    private String startScmVersion;
    @Parameter(property="endScmVersionType")
    private String endScmVersionType;
    @Parameter(property="endScmVersion")
    private String endScmVersion;
    @Parameter(property="outputFile", defaultValue="${project.artifactId}.diff")
    private File outputFile;

    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            DiffScmResult result = this.getScmManager().diff(repository, this.getFileSet(), this.getScmVersion(this.startScmVersionType, this.startScmVersion), this.getScmVersion(this.endScmVersionType, this.endScmVersion));
            this.checkResult((ScmResult)result);
            this.getLog().info((CharSequence)result.getPatch());
            try {
                if (this.outputFile != null) {
                    FileUtils.fileWrite((String)this.outputFile.getAbsolutePath(), (String)result.getPatch());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't write patch file.", (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run diff command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run diff command : ", (Exception)((Object)e));
        }
    }
}

