/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="status", aggregator=true)
public class StatusMojo
extends AbstractScmMojo {
    @Inject
    public StatusMojo(ScmManager manager, SettingsDecrypter settingsDecrypter) {
        super(manager, settingsDecrypter);
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            StatusScmResult result = this.getScmManager().status(repository, this.getFileSet());
            this.checkResult((ScmResult)result);
            File baseDir = this.getFileSet().getBasedir();
            int maxLen = 0;
            for (ScmFile file : result.getChangedFiles()) {
                maxLen = Math.max(maxLen, file.getStatus().toString().length());
            }
            for (ScmFile file : result.getChangedFiles()) {
                this.getLog().info((CharSequence)(StringUtils.leftPad((String)file.getStatus().toString(), (int)maxLen) + " status for " + this.getRelativePath(baseDir, file.getPath())));
            }
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run status command : ", (Exception)e);
        }
    }

    protected String getRelativePath(File baseDir, String path) {
        if (path.equals(baseDir.getAbsolutePath())) {
            return ".";
        }
        if (path.indexOf(baseDir.getAbsolutePath()) == 0) {
            return path.substring(baseDir.getAbsolutePath().length() + 1);
        }
        return path;
    }
}

