/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugins.surefire.report.LocalizedProperties;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;

public final class SurefireReportGenerator {
    private static final int LEFT = 1;
    private static final Object[] TAG_TYPE_START = new Object[]{2};
    private static final Object[] TAG_TYPE_END = new Object[]{3};
    private final SurefireReportParser report;
    private final boolean showSuccess;
    private final String xrefLocation;
    private List<ReportTestSuite> testSuites;

    public SurefireReportGenerator(List<File> reportsDirectories, Locale locale, boolean showSuccess, String xrefLocation, ConsoleLogger consoleLogger) {
        this.report = new SurefireReportParser(reportsDirectories, locale, consoleLogger);
        this.showSuccess = showSuccess;
        this.xrefLocation = xrefLocation;
    }

    public void doGenerateReport(LocalizedProperties bundle, Sink sink) throws MavenReportException {
        List failureList;
        this.testSuites = this.report.parseXMLReportFiles();
        sink.head();
        sink.title();
        sink.text(bundle.getReportHeader());
        sink.title_();
        sink.head_();
        sink.body();
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute((Object)"type", (Object)"application/javascript");
        sink.unknown("script", new Object[]{2}, (SinkEventAttributes)atts);
        sink.unknown("cdata", new Object[]{5, SurefireReportGenerator.javascriptToggleDisplayCode()}, null);
        sink.unknown("script", new Object[]{3}, null);
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getReportHeader());
        sink.sectionTitle1_();
        sink.section1_();
        this.constructSummarySection(bundle, sink);
        Map suitePackages = this.report.getSuitesGroupByPackage(this.testSuites);
        if (!suitePackages.isEmpty()) {
            this.constructPackagesSection(bundle, sink, suitePackages);
        }
        if (!this.testSuites.isEmpty()) {
            this.constructTestCasesSection(bundle, sink);
        }
        if (!(failureList = this.report.getFailureDetails(this.testSuites)).isEmpty()) {
            this.constructFailureDetails(sink, bundle, failureList);
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void constructSummarySection(LocalizedProperties bundle, Sink sink) {
        Map summary = this.report.getSummary(this.testSuites);
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getReportLabelSummary());
        sink.sectionTitle1_();
        SurefireReportGenerator.sinkAnchor(sink, "Summary");
        this.constructHotLinks(sink, bundle);
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1, 1, 1}, true);
        sink.tableRow();
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelTests());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelErrors());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelFailures());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelSkipped());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelSuccessRate());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelTime());
        sink.tableRow_();
        sink.tableRow();
        SurefireReportGenerator.sinkCell(sink, (String)summary.get("totalTests"));
        SurefireReportGenerator.sinkCell(sink, (String)summary.get("totalErrors"));
        SurefireReportGenerator.sinkCell(sink, (String)summary.get("totalFailures"));
        SurefireReportGenerator.sinkCell(sink, (String)summary.get("totalSkipped"));
        SurefireReportGenerator.sinkCell(sink, (String)summary.get("totalPercentage") + "%");
        SurefireReportGenerator.sinkCell(sink, (String)summary.get("totalElapsedTime"));
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
        sink.lineBreak();
        sink.paragraph();
        sink.text(bundle.getReportTextNode1());
        sink.paragraph_();
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructPackagesSection(LocalizedProperties bundle, Sink sink, Map<String, List<ReportTestSuite>> suitePackages) {
        List<ReportTestSuite> testSuiteList;
        String packageName;
        NumberFormat numberFormat = this.report.getNumberFormat();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getReportLabelPackageList());
        sink.sectionTitle1_();
        SurefireReportGenerator.sinkAnchor(sink, "Package_List");
        this.constructHotLinks(sink, bundle);
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1, 1, 1, 1}, true);
        sink.tableRow();
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelPackage());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelTests());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelErrors());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelFailures());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelSkipped());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelSuccessRate());
        SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelTime());
        sink.tableRow_();
        for (Map.Entry<String, List<ReportTestSuite>> entry : suitePackages.entrySet()) {
            sink.tableRow();
            packageName = entry.getKey();
            testSuiteList = entry.getValue();
            Map packageSummary = this.report.getSummary(testSuiteList);
            SurefireReportGenerator.sinkCellLink(sink, packageName, "#" + packageName);
            SurefireReportGenerator.sinkCell(sink, (String)packageSummary.get("totalTests"));
            SurefireReportGenerator.sinkCell(sink, (String)packageSummary.get("totalErrors"));
            SurefireReportGenerator.sinkCell(sink, (String)packageSummary.get("totalFailures"));
            SurefireReportGenerator.sinkCell(sink, (String)packageSummary.get("totalSkipped"));
            SurefireReportGenerator.sinkCell(sink, (String)packageSummary.get("totalPercentage") + "%");
            SurefireReportGenerator.sinkCell(sink, (String)packageSummary.get("totalElapsedTime"));
            sink.tableRow_();
        }
        sink.tableRows_();
        sink.table_();
        sink.lineBreak();
        sink.paragraph();
        sink.text(bundle.getReportTextNode2());
        sink.paragraph_();
        for (Map.Entry<String, List<ReportTestSuite>> entry : suitePackages.entrySet()) {
            packageName = entry.getKey();
            testSuiteList = entry.getValue();
            sink.section2();
            sink.sectionTitle2();
            sink.text(packageName);
            sink.sectionTitle2_();
            SurefireReportGenerator.sinkAnchor(sink, packageName);
            boolean showTable = false;
            for (ReportTestSuite suite : testSuiteList) {
                if (!this.showSuccess && suite.getNumberOfErrors() == 0 && suite.getNumberOfFailures() == 0) continue;
                showTable = true;
                break;
            }
            if (showTable) {
                sink.table();
                sink.tableRows(new int[]{1, 1, 1, 1, 1, 1, 1, 1}, true);
                sink.tableRow();
                SurefireReportGenerator.sinkHeader(sink, "");
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelClass());
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelTests());
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelErrors());
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelFailures());
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelSkipped());
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelSuccessRate());
                SurefireReportGenerator.sinkHeader(sink, bundle.getReportLabelTime());
                sink.tableRow_();
                for (ReportTestSuite suite : testSuiteList) {
                    if (!this.showSuccess && suite.getNumberOfErrors() == 0 && suite.getNumberOfFailures() == 0) continue;
                    this.constructTestSuiteSection(sink, numberFormat, suite);
                }
                sink.tableRows_();
                sink.table_();
            }
            sink.section2_();
        }
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructTestSuiteSection(Sink sink, NumberFormat numberFormat, ReportTestSuite suite) {
        sink.tableRow();
        sink.tableCell();
        sink.link("#" + suite.getPackageName() + '.' + suite.getName());
        if (suite.getNumberOfErrors() > 0) {
            SurefireReportGenerator.sinkIcon("error", sink);
        } else if (suite.getNumberOfFailures() > 0) {
            SurefireReportGenerator.sinkIcon("junit.framework", sink);
        } else if (suite.getNumberOfSkipped() > 0) {
            SurefireReportGenerator.sinkIcon("skipped", sink);
        } else {
            SurefireReportGenerator.sinkIcon("success", sink);
        }
        sink.link_();
        sink.tableCell_();
        SurefireReportGenerator.sinkCellLink(sink, suite.getName(), "#" + suite.getPackageName() + '.' + suite.getName());
        SurefireReportGenerator.sinkCell(sink, Integer.toString(suite.getNumberOfTests()));
        SurefireReportGenerator.sinkCell(sink, Integer.toString(suite.getNumberOfErrors()));
        SurefireReportGenerator.sinkCell(sink, Integer.toString(suite.getNumberOfFailures()));
        SurefireReportGenerator.sinkCell(sink, Integer.toString(suite.getNumberOfSkipped()));
        String percentage = this.report.computePercentage(suite.getNumberOfTests(), suite.getNumberOfErrors(), suite.getNumberOfFailures(), suite.getNumberOfSkipped());
        SurefireReportGenerator.sinkCell(sink, percentage + "%");
        SurefireReportGenerator.sinkCell(sink, numberFormat.format(suite.getTimeElapsed()));
        sink.tableRow_();
    }

    private void constructTestCasesSection(LocalizedProperties bundle, Sink sink) {
        NumberFormat numberFormat = this.report.getNumberFormat();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getReportLabelTestCases());
        sink.sectionTitle1_();
        SurefireReportGenerator.sinkAnchor(sink, "Test_Cases");
        this.constructHotLinks(sink, bundle);
        for (ReportTestSuite suite : this.testSuites) {
            List testCases = suite.getTestCases();
            if (testCases.isEmpty()) continue;
            sink.section2();
            sink.sectionTitle2();
            sink.text(suite.getName());
            sink.sectionTitle2_();
            SurefireReportGenerator.sinkAnchor(sink, suite.getPackageName() + '.' + suite.getName());
            boolean showTable = false;
            for (ReportTestCase testCase : testCases) {
                if (testCase.isSuccessful() && !this.showSuccess) continue;
                showTable = true;
                break;
            }
            if (showTable) {
                sink.table();
                sink.tableRows(new int[]{1, 1, 1}, true);
                for (ReportTestCase testCase : testCases) {
                    if (testCase.isSuccessful() && !this.showSuccess) continue;
                    SurefireReportGenerator.constructTestCaseSection(sink, numberFormat, testCase);
                }
                sink.tableRows_();
                sink.table_();
            }
            sink.section2_();
        }
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private static void constructTestCaseSection(Sink sink, NumberFormat numberFormat, ReportTestCase testCase) {
        sink.tableRow();
        sink.tableCell();
        if (testCase.getFailureType() != null) {
            sink.link("#" + SurefireReportGenerator.toHtmlId(testCase.getFullName()));
            SurefireReportGenerator.sinkIcon(testCase.getFailureType(), sink);
            sink.link_();
        } else {
            SurefireReportGenerator.sinkIcon("success", sink);
        }
        sink.tableCell_();
        if (!testCase.isSuccessful()) {
            sink.tableCell();
            SurefireReportGenerator.sinkAnchor(sink, "TC_" + SurefireReportGenerator.toHtmlId(testCase.getFullName()));
            SurefireReportGenerator.sinkLink(sink, testCase.getName(), "#" + SurefireReportGenerator.toHtmlId(testCase.getFullName()));
            SinkEventAttributeSet atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"class", (Object)"detailToggle");
            atts.addAttribute((Object)"style", (Object)"display:inline");
            sink.unknown("div", TAG_TYPE_START, (SinkEventAttributes)atts);
            SurefireReportGenerator.sinkLink(sink, "javascript:toggleDisplay('" + SurefireReportGenerator.toHtmlId(testCase.getFullName()) + "');");
            atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"style", (Object)"display:inline;");
            atts.addAttribute((Object)"id", (Object)(SurefireReportGenerator.toHtmlId(testCase.getFullName()) + "-off"));
            sink.unknown("span", TAG_TYPE_START, (SinkEventAttributes)atts);
            sink.text(" + ");
            sink.unknown("span", TAG_TYPE_END, null);
            atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"style", (Object)"display:none;");
            atts.addAttribute((Object)"id", (Object)(SurefireReportGenerator.toHtmlId(testCase.getFullName()) + "-on"));
            sink.unknown("span", TAG_TYPE_START, (SinkEventAttributes)atts);
            sink.text(" - ");
            sink.unknown("span", TAG_TYPE_END, null);
            sink.text("[ Detail ]");
            SurefireReportGenerator.sinkLink_(sink);
            sink.unknown("div", TAG_TYPE_END, null);
            sink.tableCell_();
        } else {
            SurefireReportGenerator.sinkCellAnchor(sink, testCase.getName(), "TC_" + SurefireReportGenerator.toHtmlId(testCase.getFullName()));
        }
        SurefireReportGenerator.sinkCell(sink, numberFormat.format(testCase.getTime()));
        sink.tableRow_();
        if (!testCase.isSuccessful()) {
            sink.tableRow();
            SurefireReportGenerator.sinkCell(sink, "");
            SurefireReportGenerator.sinkCell(sink, testCase.getFailureMessage());
            SurefireReportGenerator.sinkCell(sink, "");
            sink.tableRow_();
            String detail = testCase.getFailureDetail();
            if (detail != null) {
                sink.tableRow();
                SurefireReportGenerator.sinkCell(sink, "");
                sink.tableCell();
                SinkEventAttributeSet atts = new SinkEventAttributeSet();
                atts.addAttribute((Object)"id", (Object)(SurefireReportGenerator.toHtmlId(testCase.getFullName()) + SurefireReportGenerator.toHtmlIdFailure(testCase)));
                atts.addAttribute((Object)"style", (Object)"display:none;");
                sink.unknown("div", TAG_TYPE_START, (SinkEventAttributes)atts);
                sink.verbatim(null);
                sink.text(detail);
                sink.verbatim_();
                sink.unknown("div", TAG_TYPE_END, null);
                sink.tableCell_();
                SurefireReportGenerator.sinkCell(sink, "");
                sink.tableRow_();
            }
        }
    }

    private static String toHtmlId(String id) {
        return DoxiaUtils.isValidId((String)id) ? id : DoxiaUtils.encodeId((String)id, (boolean)true);
    }

    private void constructFailureDetails(Sink sink, LocalizedProperties bundle, List<ReportTestCase> failures) {
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getReportLabelFailureDetails());
        sink.sectionTitle1_();
        SurefireReportGenerator.sinkAnchor(sink, "Failure_Details");
        this.constructHotLinks(sink, bundle);
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1}, true);
        for (ReportTestCase tCase : failures) {
            sink.tableRow();
            sink.tableCell();
            String type = tCase.getFailureType();
            SurefireReportGenerator.sinkIcon(type, sink);
            sink.tableCell_();
            SurefireReportGenerator.sinkCellAnchor(sink, tCase.getName(), SurefireReportGenerator.toHtmlId(tCase.getFullName()));
            sink.tableRow_();
            String message = tCase.getFailureMessage();
            sink.tableRow();
            SurefireReportGenerator.sinkCell(sink, "");
            SurefireReportGenerator.sinkCell(sink, message == null ? type : type + ": " + message);
            sink.tableRow_();
            String detail = tCase.getFailureDetail();
            if (detail == null) continue;
            sink.tableRow();
            SurefireReportGenerator.sinkCell(sink, "");
            sink.tableCell();
            SinkEventAttributeSet atts = new SinkEventAttributeSet();
            atts.addAttribute((Object)"id", (Object)(tCase.getName() + SurefireReportGenerator.toHtmlIdFailure(tCase)));
            sink.unknown("div", TAG_TYPE_START, (SinkEventAttributes)atts);
            String fullClassName = tCase.getFullClassName();
            String errorLineNumber = tCase.getFailureErrorLine();
            if (this.xrefLocation != null) {
                String path = fullClassName.replace('.', '/');
                sink.link(this.xrefLocation + "/" + path + ".html#" + errorLineNumber);
            }
            sink.text(fullClassName + ":" + errorLineNumber);
            if (this.xrefLocation != null) {
                sink.link_();
            }
            sink.unknown("div", TAG_TYPE_END, null);
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.tableRows_();
        sink.table_();
        SurefireReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructHotLinks(Sink sink, LocalizedProperties bundle) {
        if (!this.testSuites.isEmpty()) {
            sink.paragraph();
            sink.text("[");
            SurefireReportGenerator.sinkLink(sink, bundle.getReportLabelSummary(), "#Summary");
            sink.text("]");
            sink.text(" [");
            SurefireReportGenerator.sinkLink(sink, bundle.getReportLabelPackageList(), "#Package_List");
            sink.text("]");
            sink.text(" [");
            SurefireReportGenerator.sinkLink(sink, bundle.getReportLabelTestCases(), "#Test_Cases");
            sink.text("]");
            sink.paragraph_();
        }
    }

    private static String toHtmlIdFailure(ReportTestCase tCase) {
        return tCase.hasError() ? "-error" : "-failure";
    }

    private static void sinkLineBreak(Sink sink) {
        sink.lineBreak();
    }

    private static void sinkIcon(String type, Sink sink) {
        sink.figure();
        if (type.startsWith("junit.framework") || "skipped".equals(type)) {
            sink.figureGraphics("images/icon_warning_sml.gif");
        } else if (type.startsWith("success")) {
            sink.figureGraphics("images/icon_success_sml.gif");
        } else {
            sink.figureGraphics("images/icon_error_sml.gif");
        }
        sink.figure_();
    }

    private static void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private static void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private static void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private static void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        SurefireReportGenerator.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private static void sinkCellAnchor(Sink sink, String text, String anchor) {
        sink.tableCell();
        SurefireReportGenerator.sinkAnchor(sink, anchor);
        sink.text(text);
        sink.tableCell_();
    }

    private static void sinkAnchor(Sink sink, String anchor) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"name", anchor}));
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private static void sinkLink(Sink sink, String href) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"href", href}));
    }

    private static void sinkLink_(Sink sink) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private static String javascriptToggleDisplayCode() {
        return "\nfunction toggleDisplay(elementId) {\n var elm = document.getElementById(elementId + '-error');\n if (elm == null) {\n  elm = document.getElementById(elementId + '-failure');\n }\n if (elm && typeof elm.style != \"undefined\") {\n  if (elm.style.display == \"none\") {\n   elm.style.display = \"\";\n   document.getElementById(elementId + '-off').style.display = \"none\";\n   document.getElementById(elementId + '-on').style.display = \"inline\";\n  } else if (elm.style.display == \"\") {   elm.style.display = \"none\";\n   document.getElementById(elementId + '-off').style.display = \"inline\";\n   document.getElementById(elementId + '-on').style.display = \"none\";\n  } \n } \n }\n//";
    }
}

