/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Map;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForDevelopmentPhase
extends AbstractRewritePomsPhase {
    @Override
    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result, String commonBasedir) throws ReleaseExecutionException {
        Element scmRoot;
        if (project.getScm() != null && (scmRoot = rootElement.getChild("scm", namespace)) != null) {
            Map originalScmInfo = releaseDescriptor.getOriginalScmInfo();
            if (!originalScmInfo.containsKey(projectId)) {
                throw new ReleaseExecutionException("Unable to find original SCM info for '" + project.getName() + "'");
            }
            ScmTranslator translator = this.getScmTranslators().get(scmRepository.getProvider());
            if (translator != null) {
                Scm scm = (Scm)originalScmInfo.get(projectId);
                if (scm != null) {
                    this.rewriteElement("connection", scm.getConnection(), scmRoot, namespace);
                    this.rewriteElement("developerConnection", scm.getDeveloperConnection(), scmRoot, namespace);
                    this.rewriteElement("url", scm.getUrl(), scmRoot, namespace);
                    this.rewriteElement("tag", translator.resolveTag(scm.getTag()), scmRoot, namespace);
                } else {
                    this.rewriteElement("scm", null, rootElement, namespace);
                }
            } else {
                String message = "No SCM translator found - skipping rewrite";
                result.appendDebug(message);
                this.getLogger().debug(message);
            }
        }
    }

    @Override
    protected Map<String, String> getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List<MavenProject> reactorProjects, boolean simulate) {
        return simulate ? releaseDescriptor.getOriginalVersions(reactorProjects) : releaseDescriptor.getReleaseVersions();
    }

    @Override
    protected Map<String, String> getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getDevelopmentVersions();
    }

    @Override
    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, Map<String, Map<String, String>> resolvedSnapshotsMap) {
        Map<String, String> versionsMap = resolvedSnapshotsMap.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return versionsMap.get("dev");
        }
        return null;
    }
}

