/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import org.apache.commons.validator.EmailValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.reporting.MavenReportRenderer;
import org.codehaus.doxia.sink.Sink;

public abstract class AbstractMavenReportRenderer
implements MavenReportRenderer {
    protected Sink sink;
    private int section = 0;

    public AbstractMavenReportRenderer(Sink sink) {
        this.sink = sink;
    }

    public void render() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.renderBody();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    protected void startTable() {
        this.sink.table();
    }

    protected void endTable() {
        this.sink.table_();
    }

    protected void startSection(String name) {
        ++this.section;
        switch (this.section) {
            case 1: {
                this.sink.section1();
                this.sink.sectionTitle1();
                break;
            }
            case 2: {
                this.sink.section2();
                this.sink.sectionTitle2();
                break;
            }
            case 3: {
                this.sink.section3();
                this.sink.sectionTitle3();
                break;
            }
            case 4: {
                this.sink.section4();
                this.sink.sectionTitle4();
                break;
            }
            case 5: {
                this.sink.section5();
                this.sink.sectionTitle5();
                break;
            }
        }
        this.sink.text(name);
        switch (this.section) {
            case 1: {
                this.sink.sectionTitle1_();
                break;
            }
            case 2: {
                this.sink.sectionTitle2_();
                break;
            }
            case 3: {
                this.sink.sectionTitle3_();
                break;
            }
            case 4: {
                this.sink.sectionTitle4_();
                break;
            }
            case 5: {
                this.sink.sectionTitle5_();
                break;
            }
        }
    }

    protected void endSection() {
        switch (this.section) {
            case 1: {
                this.sink.section1_();
                break;
            }
            case 2: {
                this.sink.section2_();
                break;
            }
            case 3: {
                this.sink.section3_();
                break;
            }
            case 4: {
                this.sink.section4_();
                break;
            }
            case 5: {
                this.sink.section5_();
                break;
            }
        }
        --this.section;
        if (this.section < 0) {
            throw new IllegalStateException("Too many closing sections");
        }
    }

    protected void tableHeaderCell(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void tableCell(String text) {
        this.sink.tableCell();
        if (text != null) {
            this.sink.text(text);
        } else {
            this.sink.nonBreakingSpace();
        }
        this.sink.tableCell_();
    }

    protected void tableCellWithLink(String text, String href) {
        this.sink.tableCell();
        if (text != null) {
            if (href != null) {
                String[] schemes = new String[]{"http", "https"};
                UrlValidator urlValidator = new UrlValidator(schemes);
                if (EmailValidator.getInstance().isValid(href)) {
                    this.link("mailto:" + href, text);
                } else if (href.toLowerCase().startsWith("mailto:")) {
                    this.link(href, text);
                } else if (urlValidator.isValid(href)) {
                    this.link(href, text);
                } else {
                    this.sink.text(text);
                }
            } else {
                this.sink.text(text);
            }
        } else {
            this.sink.nonBreakingSpace();
        }
        this.sink.tableCell_();
    }

    protected void tableRow(String[] content) {
        this.sink.tableRow();
        for (int i = 0; i < content.length; ++i) {
            this.tableCell(content[i]);
        }
        this.sink.tableRow_();
    }

    protected void tableRowWithLink(String[] texts, String[] hrefs) {
        if (hrefs.length != texts.length) {
            throw new IllegalArgumentException("The arrays should have the same size");
        }
        this.sink.tableRow();
        for (int i = 0; i < texts.length; ++i) {
            this.tableCellWithLink(texts[i], hrefs[i]);
        }
        this.sink.tableRow_();
    }

    protected void tableHeader(String[] content) {
        this.sink.tableRow();
        for (int i = 0; i < content.length; ++i) {
            this.tableHeaderCell(content[i]);
        }
        this.sink.tableRow_();
    }

    protected void tableCaption(String caption) {
        this.sink.tableCaption();
        this.sink.text(caption);
        this.sink.tableCaption_();
    }

    protected void paragraph(String paragraph) {
        this.sink.paragraph();
        this.sink.text(paragraph);
        this.sink.paragraph_();
    }

    protected void link(String href, String name) {
        this.sink.link(href);
        this.sink.text(name);
        this.sink.link_();
    }

    public abstract String getTitle();

    protected abstract void renderBody();
}

