/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.reporting.exec.ReportPlugin;
import org.apache.maven.reporting.exec.ReportSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenReportExecutor.class)
public class DefaultMavenReportExecutor
implements MavenReportExecutor {
    @Requirement
    private Logger logger;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    @Requirement
    protected LifecycleExecutor lifecycleExecutor;
    @Requirement
    protected PluginVersionResolver pluginVersionResolver;
    private static final List<String> IMPORTS = Arrays.asList("org.apache.maven.reporting.MavenReport", "org.apache.maven.reporting.MavenMultiPageReport", "org.apache.maven.doxia.siterenderer.Renderer", "org.apache.maven.doxia.sink.SinkFactory", "org.codehaus.doxia.sink.Sink", "org.apache.maven.doxia.sink.Sink", "org.apache.maven.doxia.sink.SinkEventAttributes", "org.apache.maven.doxia.logging.LogEnabled", "org.apache.maven.doxia.logging.Log");
    private static final ExclusionsDependencyFilter EXCLUDES = new ExclusionsDependencyFilter(Arrays.asList("doxia-site-renderer", "doxia-sink-api", "maven-reporting-api"));

    @Override
    public List<MavenReportExecution> buildMavenReports(MavenReportExecutorRequest mavenReportExecutorRequest) throws MojoExecutionException {
        if (mavenReportExecutorRequest.getReportPlugins() == null) {
            return Collections.emptyList();
        }
        this.getLog().debug("DefaultMavenReportExecutor.buildMavenReports()");
        ArrayList<String> reportPluginKeys = new ArrayList<String>();
        ArrayList<MavenReportExecution> reports = new ArrayList<MavenReportExecution>();
        String pluginKey = "";
        try {
            for (ReportPlugin reportPlugin : mavenReportExecutorRequest.getReportPlugins()) {
                pluginKey = reportPlugin.getGroupId() + ":" + reportPlugin.getArtifactId();
                this.buildReportPlugin(mavenReportExecutorRequest, reportPlugin, reportPluginKeys, reports);
            }
            return reports;
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to get report for " + pluginKey, e);
        }
    }

    protected void buildReportPlugin(MavenReportExecutorRequest mavenReportExecutorRequest, ReportPlugin reportPlugin, List<String> reportPluginKeys, List<MavenReportExecution> reports) throws Exception {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        String pluginKey = reportPlugin.getGroupId() + ":" + reportPlugin.getArtifactId();
        if (reportPluginKeys.contains(pluginKey)) {
            this.logger.info("plugin " + pluginKey + " will be executed more than one time");
        } else {
            reportPluginKeys.add(pluginKey);
        }
        DefaultRepositoryRequest repositoryRequest = new DefaultRepositoryRequest();
        repositoryRequest.setLocalRepository(mavenReportExecutorRequest.getLocalRepository());
        repositoryRequest.setRemoteRepositories(mavenReportExecutorRequest.getProject().getPluginArtifactRepositories());
        plugin.setVersion(this.getPluginVersion(reportPlugin, (RepositoryRequest)repositoryRequest, mavenReportExecutorRequest));
        this.mergePluginToReportPlugin(mavenReportExecutorRequest, plugin, reportPlugin);
        this.logger.info("configuring report plugin " + plugin.getId());
        MavenSession session = mavenReportExecutorRequest.getMavenSession();
        List remoteRepositories = session.getCurrentProject().getRemotePluginRepositories();
        PluginDescriptor pluginDescriptor = this.mavenPluginManager.getPluginDescriptor(plugin, remoteRepositories, session.getRepositorySession());
        LinkedHashMap<String, PlexusConfiguration> goalsWithConfiguration = new LinkedHashMap<String, PlexusConfiguration>();
        if (reportPlugin.getReportSets().isEmpty() && reportPlugin.getReports().isEmpty()) {
            List mojoDescriptors = pluginDescriptor.getMojos();
            for (MojoDescriptor mojoDescriptor : mojoDescriptors) {
                goalsWithConfiguration.put(mojoDescriptor.getGoal(), mojoDescriptor.getConfiguration());
            }
        } else {
            for (ReportSet reportSet : reportPlugin.getReportSets()) {
                for (String report : reportSet.getReports()) {
                    goalsWithConfiguration.put(report, reportSet.getConfiguration());
                }
            }
            for (String string : reportPlugin.getReports()) {
                goalsWithConfiguration.put(string, reportPlugin.getConfiguration());
            }
        }
        for (Map.Entry entry : goalsWithConfiguration.entrySet()) {
            MojoDescriptor mojoDescriptor;
            mojoDescriptor = pluginDescriptor.getMojo((String)entry.getKey());
            if (mojoDescriptor == null) {
                throw new MojoNotFoundException((String)entry.getKey(), pluginDescriptor);
            }
            MojoExecution mojoExecution = new MojoExecution(plugin, (String)entry.getKey(), "report:" + (String)entry.getKey());
            mojoExecution.setConfiguration(this.convert(mojoDescriptor));
            if (reportPlugin.getConfiguration() != null || entry.getValue() != null) {
                Xpp3Dom reportConfiguration = reportPlugin.getConfiguration() == null ? new Xpp3Dom("fake") : this.convert(reportPlugin.getConfiguration());
                Xpp3Dom mergedConfigurationWithReportSet = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)this.convert((PlexusConfiguration)entry.getValue()), (Xpp3Dom)reportConfiguration);
                Xpp3Dom mergedConfiguration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)mergedConfigurationWithReportSet, (Xpp3Dom)this.convert(mojoDescriptor));
                Xpp3Dom cleanedConfiguration = new Xpp3Dom("configuration");
                if (mergedConfiguration.getChildren() != null) {
                    for (Xpp3Dom parameter : mergedConfiguration.getChildren()) {
                        if (!mojoDescriptor.getParameterMap().containsKey(parameter.getName())) continue;
                        cleanedConfiguration.addChild(parameter);
                    }
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug("mojoExecution mergedConfiguration: " + mergedConfiguration);
                    this.getLog().debug("mojoExecution cleanedConfiguration: " + cleanedConfiguration);
                }
                mojoExecution.setConfiguration(cleanedConfiguration);
            }
            mojoExecution.setMojoDescriptor(mojoDescriptor);
            this.mavenPluginManager.setupPluginRealm(pluginDescriptor, mavenReportExecutorRequest.getMavenSession(), Thread.currentThread().getContextClassLoader(), IMPORTS, (DependencyFilter)EXCLUDES);
            MavenReport mavenReport = this.getConfiguredMavenReport(mojoExecution, pluginDescriptor, mavenReportExecutorRequest);
            if (mavenReport == null) continue;
            MavenReportExecution mavenReportExecution = new MavenReportExecution(mojoExecution.getPlugin(), mavenReport, (ClassLoader)pluginDescriptor.getClassRealm());
            this.lifecycleExecutor.calculateForkedExecutions(mojoExecution, mavenReportExecutorRequest.getMavenSession());
            if (!mojoExecution.getForkedExecutions().isEmpty()) {
                this.lifecycleExecutor.executeForkedExecutions(mojoExecution, mavenReportExecutorRequest.getMavenSession());
            }
            if (!this.canGenerateReport(mavenReport, mojoExecution)) continue;
            reports.add(mavenReportExecution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canGenerateReport(MavenReport mavenReport, MojoExecution mojoExecution) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)mojoExecution.getMojoDescriptor().getRealm());
            boolean bl = mavenReport.canGenerateReport();
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private MavenReport getConfiguredMavenReport(MojoExecution mojoExecution, PluginDescriptor pluginDescriptor, MavenReportExecutorRequest mavenReportExecutorRequest) throws PluginContainerException, PluginConfigurationException {
        try {
            if (!this.isMavenReport(mojoExecution, pluginDescriptor)) {
                return null;
            }
            Mojo mojo = (Mojo)this.mavenPluginManager.getConfiguredMojo(Mojo.class, mavenReportExecutorRequest.getMavenSession(), mojoExecution);
            return (MavenReport)mojo;
        }
        catch (ClassCastException e) {
            this.getLog().warn("skip ClassCastException " + e.getMessage());
            return null;
        }
        catch (PluginContainerException e) {
            if (e.getCause() != null && e.getCause() instanceof NoClassDefFoundError && e.getMessage().contains("PluginRegistry")) {
                this.getLog().warn("skip NoClassDefFoundError with PluginRegistry ");
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug(e.getMessage(), (Throwable)e);
                }
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMavenReport(MojoExecution mojoExecution, PluginDescriptor pluginDescriptor) {
        Class mojoClass;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)mojoExecution.getMojoDescriptor().getRealm());
        try {
            mojoClass = pluginDescriptor.getClassRealm().loadClass(mojoExecution.getMojoDescriptor().getImplementation());
        }
        catch (ClassNotFoundException e) {
            this.getLog().warn("skip ClassNotFoundException mojoExecution.goal '" + mojoExecution.getGoal() + "': " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)mojoExecution.getMojoDescriptor().getRealm());
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoExecution.getGoal());
            boolean isMavenReport = MavenReport.class.isAssignableFrom(mojoClass);
            if (this.getLog().isDebugEnabled()) {
                if (mojoDescriptor != null && mojoDescriptor.getImplementationClass() != null) {
                    this.getLog().debug("class " + mojoDescriptor.getImplementationClass().getName() + " isMavenReport: " + isMavenReport);
                }
                if (!isMavenReport) {
                    this.getLog().debug("skip non MavenReport " + mojoExecution.getMojoDescriptor().getId());
                }
            }
            boolean bl = isMavenReport;
            return bl;
        }
        catch (LinkageError e) {
            this.getLog().warn("skip LinkageError mojoExecution.goal '" + mojoExecution.getGoal() + "': " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        PlexusConfiguration config = mojoDescriptor.getMojoConfiguration();
        return config != null ? this.convert(config) : new Xpp3Dom("configuration");
    }

    private Xpp3Dom convert(PlexusConfiguration config) {
        if (config == null) {
            return null;
        }
        Xpp3Dom dom = new Xpp3Dom(config.getName());
        dom.setValue(config.getValue(null));
        for (String attrib : config.getAttributeNames()) {
            dom.setAttribute(attrib, config.getAttribute(attrib, null));
        }
        int n = config.getChildCount();
        for (int i = 0; i < n; ++i) {
            dom.addChild(this.convert(config.getChild(i)));
        }
        return dom;
    }

    private Logger getLog() {
        return this.logger;
    }

    protected String getPluginVersion(ReportPlugin reportPlugin, RepositoryRequest repositoryRequest, MavenReportExecutorRequest mavenReportExecutorRequest) throws PluginVersionResolutionException {
        Plugin plugin;
        String reportPluginKey = reportPlugin.getGroupId() + ':' + reportPlugin.getArtifactId();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("resolving version for " + reportPluginKey);
        }
        if (reportPlugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the reporting.plugins section: " + reportPlugin.getVersion());
            }
            return reportPlugin.getVersion();
        }
        MavenProject project = mavenReportExecutorRequest.getProject();
        if (project.getBuild() != null && (plugin = this.find(reportPlugin, project.getBuild().getPlugins())) != null && plugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the build.plugins section: " + plugin.getVersion());
            }
            return plugin.getVersion();
        }
        if (project.getBuild() != null && project.getBuild().getPluginManagement() != null && (plugin = this.find(reportPlugin, project.getBuild().getPluginManagement().getPlugins())) != null && plugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the build.pluginManagement.plugins section: " + plugin.getVersion());
            }
            return plugin.getVersion();
        }
        this.logger.warn("Report plugin " + reportPluginKey + " has an empty version.");
        this.logger.warn("");
        this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
        this.logger.warn("");
        this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
        plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        DefaultPluginVersionRequest pluginVersionRequest = new DefaultPluginVersionRequest(plugin, mavenReportExecutorRequest.getMavenSession());
        PluginVersionResult result = this.pluginVersionResolver.resolve((PluginVersionRequest)pluginVersionRequest);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("resolved " + reportPluginKey + " version from repository: " + result.getVersion());
        }
        return result.getVersion();
    }

    private Plugin find(ReportPlugin reportPlugin, List<Plugin> plugins) {
        if (plugins == null) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!StringUtils.equals((String)plugin.getArtifactId(), (String)reportPlugin.getArtifactId()) || !StringUtils.equals((String)plugin.getGroupId(), (String)reportPlugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private void mergePluginToReportPlugin(MavenReportExecutorRequest mavenReportExecutorRequest, Plugin buildPlugin, ReportPlugin reportPlugin) {
        Plugin configuredPlugin = this.find(reportPlugin, mavenReportExecutorRequest.getProject().getBuild().getPlugins());
        if (configuredPlugin != null && !configuredPlugin.getDependencies().isEmpty()) {
            buildPlugin.getDependencies().addAll(configuredPlugin.getDependencies());
        }
    }
}

