/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManager;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactory;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named(value="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory {
    public static final String NAME = "enhanced";
    static final String CONFIG_PROPS_PREFIX = "aether.lrm.enhanced.";
    public static final String CONFIG_PROP_TRACKING_FILENAME = "aether.lrm.enhanced.trackingFilename";
    public static final String DEFAULT_TRACKING_FILENAME = "_remote.repositories";
    private float priority = 10.0f;
    private final LocalPathComposer localPathComposer;
    private final TrackingFileManager trackingFileManager;
    private final LocalPathPrefixComposerFactory localPathPrefixComposerFactory;

    @Inject
    public EnhancedLocalRepositoryManagerFactory(LocalPathComposer localPathComposer, TrackingFileManager trackingFileManager, LocalPathPrefixComposerFactory localPathPrefixComposerFactory) {
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
        this.localPathPrefixComposerFactory = Objects.requireNonNull(localPathPrefixComposerFactory);
    }

    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        String trackingFilename = ConfigUtils.getString((RepositorySystemSession)session, (String)"", (String[])new String[]{CONFIG_PROP_TRACKING_FILENAME});
        if (trackingFilename.isEmpty() || trackingFilename.contains("/") || trackingFilename.contains("\\") || trackingFilename.contains("..")) {
            trackingFilename = DEFAULT_TRACKING_FILENAME;
        }
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir(), this.localPathComposer, trackingFilename, this.trackingFileManager, this.localPathPrefixComposerFactory.createComposer(session));
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public float getPriority() {
        return this.priority;
    }

    public EnhancedLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

