/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedLockFactorySupport
implements NamedLockFactory {
    public static final String SYSTEM_PROP_DIAGNOSTIC_ENABLED = "aether.named.diagnostic.enabled";
    private static final boolean DIAGNOSTIC_ENABLED = Boolean.getBoolean("aether.named.diagnostic.enabled");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, NamedLockHolder> locks = new ConcurrentHashMap<String, NamedLockHolder>();
    private final boolean diagnosticEnabled;

    public NamedLockFactorySupport() {
        this(DIAGNOSTIC_ENABLED);
    }

    public NamedLockFactorySupport(boolean diagnosticEnabled) {
        this.diagnosticEnabled = diagnosticEnabled;
    }

    public boolean isDiagnosticEnabled() {
        return this.diagnosticEnabled;
    }

    @Override
    public NamedLockSupport getLock(String name) {
        return this.locks.compute(name, (k, v) -> {
            if (v == null) {
                v = new NamedLockHolder(this.createLock((String)k));
            }
            ((NamedLockHolder)v).incRef();
            return v;
        }).namedLock;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public <E extends Throwable> E onFailure(E failure) {
        if (this.isDiagnosticEnabled()) {
            HashMap<String, NamedLockHolder> locks = new HashMap<String, NamedLockHolder>(this.locks);
            int activeLocks = locks.size();
            this.logger.info("Diagnostic dump of lock factory");
            this.logger.info("===============================");
            this.logger.info("Implementation: {}", (Object)this.getClass().getName());
            this.logger.info("Active locks: {}", (Object)activeLocks);
            this.logger.info("");
            if (activeLocks > 0) {
                for (Map.Entry entry : locks.entrySet()) {
                    String name = (String)entry.getKey();
                    int refCount = ((NamedLockHolder)entry.getValue()).referenceCount.get();
                    NamedLockSupport lock = ((NamedLockHolder)entry.getValue()).namedLock;
                    this.logger.info("Name: {}", (Object)name);
                    this.logger.info("RefCount: {}", (Object)refCount);
                    Map<Thread, Deque<String>> diag = lock.diagnosticState();
                    diag.forEach((key, value) -> this.logger.info("  {} -> {}", key, value));
                }
                this.logger.info("");
            }
        }
        return failure;
    }

    public void closeLock(String name) {
        this.locks.compute(name, (k, v) -> {
            if (v != null && ((NamedLockHolder)v).decRef() == 0) {
                this.destroyLock(((NamedLockHolder)v).namedLock.name());
                return null;
            }
            return v;
        });
    }

    protected abstract NamedLockSupport createLock(String var1);

    protected void destroyLock(String name) {
    }

    private static final class NamedLockHolder {
        private final NamedLockSupport namedLock;
        private final AtomicInteger referenceCount;

        private NamedLockHolder(NamedLockSupport namedLock) {
            this.namedLock = Objects.requireNonNull(namedLock);
            this.referenceCount = new AtomicInteger(0);
        }

        private int incRef() {
            return this.referenceCount.incrementAndGet();
        }

        private int decRef() {
            return this.referenceCount.decrementAndGet();
        }

        public String toString() {
            return "[refCount=" + this.referenceCount.get() + ", lock=" + this.namedLock + "]";
        }
    }
}

