/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmBranchParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.blame.BlameScmRequest;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmUrlUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScmManager
implements ScmManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ScmProvider> scmProviders = new ConcurrentHashMap<String, ScmProvider>();
    private final Map<String, String> userProviderTypes = new ConcurrentHashMap<String, String>();

    protected void setScmProviders(Map<String, ScmProvider> providers) {
        Objects.requireNonNull(providers);
        this.scmProviders.clear();
        providers.forEach(this.scmProviders::putIfAbsent);
    }

    @Deprecated
    protected void addScmProvider(String providerType, ScmProvider provider) {
        this.setScmProvider(providerType, provider);
    }

    @Override
    public void setScmProvider(String providerType, ScmProvider provider) {
        Objects.requireNonNull(providerType);
        Objects.requireNonNull(provider);
        this.scmProviders.put(providerType, provider);
    }

    @Override
    public ScmProvider getProviderByUrl(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        Objects.requireNonNull(scmUrl, "The scm url cannot be null.");
        String providerType = ScmUrlUtils.getProvider(scmUrl);
        return this.getProviderByType(providerType);
    }

    @Override
    public void setScmProviderImplementation(String providerType, String providerImplementation) {
        Objects.requireNonNull(providerType);
        Objects.requireNonNull(providerImplementation);
        this.userProviderTypes.put(providerType, providerImplementation);
    }

    @Override
    public ScmProvider getProviderByType(String providerType) throws NoSuchScmProviderException {
        ScmProvider scmProvider;
        String usedProviderType = System.getProperty("maven.scm.provider." + providerType + ".implementation");
        if (usedProviderType == null) {
            usedProviderType = this.userProviderTypes.getOrDefault(providerType, providerType);
        }
        if ((scmProvider = this.scmProviders.get(usedProviderType)) == null) {
            throw new NoSuchScmProviderException(usedProviderType);
        }
        return scmProvider;
    }

    @Override
    public ScmProvider getProviderByRepository(ScmRepository repository) throws NoSuchScmProviderException {
        return this.getProviderByType(repository.getProvider());
    }

    @Override
    public ScmRepository makeScmRepository(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        Objects.requireNonNull(scmUrl, "The scm url cannot be null.");
        char delimiter = ScmUrlUtils.getDelimiter(scmUrl).charAt(0);
        String providerType = ScmUrlUtils.getProvider(scmUrl);
        ScmProvider provider = this.getProviderByType(providerType);
        String scmSpecificUrl = this.cleanScmUrl(scmUrl.substring(providerType.length() + 5));
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(scmSpecificUrl, delimiter);
        return new ScmRepository(providerType, providerRepository);
    }

    protected String cleanScmUrl(String scmUrl) {
        Objects.requireNonNull(scmUrl, "The scm url cannot be null.");
        String pathSeparator = "";
        int indexOfDoubleDot = -1;
        if (scmUrl.indexOf("../") > 1) {
            pathSeparator = "/";
            indexOfDoubleDot = scmUrl.indexOf("../");
        }
        if (scmUrl.indexOf("..\\") > 1) {
            pathSeparator = "\\";
            indexOfDoubleDot = scmUrl.indexOf("..\\");
        }
        if (indexOfDoubleDot > 1) {
            int startOfTextToRemove = scmUrl.substring(0, indexOfDoubleDot - 1).lastIndexOf(pathSeparator);
            String beginUrl = "";
            if (startOfTextToRemove >= 0) {
                beginUrl = scmUrl.substring(0, startOfTextToRemove);
            }
            String endUrl = scmUrl.substring(indexOfDoubleDot + 3);
            scmUrl = beginUrl + pathSeparator + endUrl;
            if (scmUrl.indexOf("../") > 1 || scmUrl.indexOf("..\\") > 1) {
                scmUrl = this.cleanScmUrl(scmUrl);
            }
        }
        return scmUrl;
    }

    @Override
    public ScmRepository makeProviderScmRepository(String providerType, File path) throws ScmRepositoryException, UnknownRepositoryStructure, NoSuchScmProviderException {
        Objects.requireNonNull(providerType, "The provider type cannot be null.");
        ScmProvider provider = this.getProviderByType(providerType);
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(path);
        return new ScmRepository(providerType, providerRepository);
    }

    @Override
    public List<String> validateScmRepository(String scmUrl) {
        ScmProvider provider;
        ArrayList<String> messages = new ArrayList<String>(ScmUrlUtils.validate(scmUrl));
        String providerType = ScmUrlUtils.getProvider(scmUrl);
        try {
            provider = this.getProviderByType(providerType);
        }
        catch (NoSuchScmProviderException e) {
            messages.add("No such provider installed '" + providerType + "'.");
            return messages;
        }
        String scmSpecificUrl = this.cleanScmUrl(scmUrl.substring(providerType.length() + 5));
        List<String> providerMessages = provider.validateScmUrl(scmSpecificUrl, ScmUrlUtils.getDelimiter(scmUrl).charAt(0));
        Objects.requireNonNull(providerMessages, "The SCM provider cannot return null from validateScmUrl().");
        messages.addAll(providerMessages);
        return messages;
    }

    @Override
    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).add(repository, fileSet);
    }

    @Override
    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        return this.getProviderByRepository(repository).add(repository, fileSet, message);
    }

    @Override
    public BranchScmResult branch(ScmRepository repository, ScmFileSet fileSet, String branchName) throws ScmException {
        ScmBranchParameters scmBranchParameters = new ScmBranchParameters("");
        return this.getProviderByRepository(repository).branch(repository, fileSet, branchName, scmBranchParameters);
    }

    @Override
    public BranchScmResult branch(ScmRepository repository, ScmFileSet fileSet, String branchName, String message) throws ScmException {
        ScmBranchParameters scmBranchParameters = new ScmBranchParameters(message);
        return this.getProviderByRepository(repository).branch(repository, fileSet, branchName, scmBranchParameters);
    }

    @Override
    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, ScmBranch branch) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startDate, endDate, numDays, branch);
    }

    @Override
    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, ScmBranch branch, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startDate, endDate, numDays, branch, datePattern);
    }

    @Override
    public ChangeLogScmResult changeLog(ChangeLogScmRequest scmRequest) throws ScmException {
        return this.getProviderByRepository(scmRequest.getScmRepository()).changeLog(scmRequest);
    }

    @Override
    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startVersion, endVersion);
    }

    @Override
    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, ScmVersion startRevision, ScmVersion endRevision, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).changeLog(repository, fileSet, startRevision, endRevision, datePattern);
    }

    @Override
    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        return this.getProviderByRepository(repository).checkIn(repository, fileSet, message);
    }

    @Override
    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, ScmVersion revision, String message) throws ScmException {
        return this.getProviderByRepository(repository).checkIn(repository, fileSet, revision, message);
    }

    @Override
    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet);
    }

    @Override
    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet, version);
    }

    @Override
    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, boolean recursive) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet, recursive);
    }

    @Override
    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, boolean recursive) throws ScmException {
        return this.getProviderByRepository(repository).checkOut(repository, fileSet, version, recursive);
    }

    @Override
    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        return this.getProviderByRepository(repository).diff(repository, fileSet, startVersion, endVersion);
    }

    @Override
    public EditScmResult edit(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).edit(repository, fileSet);
    }

    @Override
    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet);
    }

    @Override
    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet, version);
    }

    @Override
    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet, String outputDirectory) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet, (ScmVersion)null, outputDirectory);
    }

    @Override
    public ExportScmResult export(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, String outputDirectory) throws ScmException {
        return this.getProviderByRepository(repository).export(repository, fileSet, version, outputDirectory);
    }

    @Override
    public ListScmResult list(ScmRepository repository, ScmFileSet fileSet, boolean recursive, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).list(repository, fileSet, recursive, version);
    }

    @Override
    public MkdirScmResult mkdir(ScmRepository repository, ScmFileSet fileSet, String message, boolean createInLocal) throws ScmException {
        return this.getProviderByRepository(repository).mkdir(repository, fileSet, message, createInLocal);
    }

    @Override
    public RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        return this.getProviderByRepository(repository).remove(repository, fileSet, message);
    }

    @Override
    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).status(repository, fileSet);
    }

    @Override
    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tagName) throws ScmException {
        return this.tag(repository, fileSet, tagName, "");
    }

    @Override
    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tagName, String message) throws ScmException {
        ScmTagParameters scmTagParameters = new ScmTagParameters(message);
        return this.getProviderByRepository(repository).tag(repository, fileSet, tagName, scmTagParameters);
    }

    @Override
    public UnEditScmResult unedit(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).unedit(repository, fileSet);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, boolean runChangelog) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, runChangelog);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, boolean runChangelog) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, runChangelog);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, (ScmVersion)null, datePattern);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, datePattern);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, Date lastUpdate) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, (ScmVersion)null, lastUpdate);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, Date lastUpdate) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, lastUpdate);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, Date lastUpdate, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, (ScmVersion)null, lastUpdate, datePattern);
    }

    @Override
    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, ScmVersion version, Date lastUpdate, String datePattern) throws ScmException {
        return this.getProviderByRepository(repository).update(repository, fileSet, version, lastUpdate, datePattern);
    }

    @Override
    public BlameScmResult blame(ScmRepository repository, ScmFileSet fileSet, String filename) throws ScmException {
        return this.getProviderByRepository(repository).blame(repository, fileSet, filename);
    }

    @Override
    public BlameScmResult blame(BlameScmRequest blameScmRequest) throws ScmException {
        return this.getProviderByRepository(blameScmRequest.getScmRepository()).blame(blameScmRequest);
    }
}

