/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.cli;

import java.util.List;
import java.util.Map;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.accurev.FileDifference;
import org.apache.maven.scm.provider.accurev.cli.XppStreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffConsumer
extends XppStreamConsumer {
    private List<FileDifference> results;
    private FileDifference currentDifference;

    public DiffConsumer(ScmLogger logger, List<FileDifference> results) {
        super(logger);
        this.results = results;
    }

    @Override
    protected void startTag(List<String> tagPath, Map<String, String> attributes) {
        String tagName = DiffConsumer.getTagName(tagPath);
        if ("Element".equals(tagName)) {
            this.currentDifference = new FileDifference();
        } else if ("Stream2".equals(tagName) && attributes.get("Name") != null) {
            this.currentDifference.setElementId(Long.parseLong(attributes.get("eid")));
            this.currentDifference.setNewVersion(attributes.get("Name"), attributes.get("Version"));
        } else if ("Stream1".equals(tagName) && attributes.get("Name") != null) {
            this.currentDifference.setElementId(Long.parseLong(attributes.get("eid")));
            this.currentDifference.setOldVersion(attributes.get("Name"), attributes.get("Version"));
        }
    }

    @Override
    protected void endTag(List<String> tagPath) {
        String tagName = DiffConsumer.getTagName(tagPath);
        if ("Element".equals(tagName) && (this.currentDifference.getNewFile() != null || this.currentDifference.getOldFile() != null)) {
            this.results.add(this.currentDifference);
        }
    }
}

