/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.scm.providers.gitlib.settings;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Settings
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *              git format allowed by changelog command.
     *           
     */
    private String revParseDateFormat = "yyyy-MM-dd HH:mm:ss";

    /**
     * 
     *              Traces the execution of a git command.
     *              could be 1,2, true or a file location
     *           .
     */
    private String traceGitCommand = "";

    /**
     * 
     *              The actual name of the git executable
     *           .
     */
    private String gitCommand = "git";

    /**
     * use the option --no-verify (can prevent trailing whitespace
     * issue with cygwin).
     */
    private boolean commitNoVerify = false;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the actual name of the git executable.
     * 
     * @return String
     */
    public String getGitCommand()
    {
        return this.gitCommand;
    } //-- String getGitCommand()

    /**
     * Get the modelEncoding field.
     * 
     * @return String
     */
    public String getModelEncoding()
    {
        return this.modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get git format allowed by changelog command.
     * 
     * @return String
     */
    public String getRevParseDateFormat()
    {
        return this.revParseDateFormat;
    } //-- String getRevParseDateFormat()

    /**
     * Get traces the execution of a git command.
     *              could be 1,2, true or a file location.
     * 
     * @return String
     */
    public String getTraceGitCommand()
    {
        return this.traceGitCommand;
    } //-- String getTraceGitCommand()

    /**
     * Get use the option --no-verify (can prevent trailing
     * whitespace issue with cygwin).
     * 
     * @return boolean
     */
    public boolean isCommitNoVerify()
    {
        return this.commitNoVerify;
    } //-- boolean isCommitNoVerify()

    /**
     * Set use the option --no-verify (can prevent trailing
     * whitespace issue with cygwin).
     * 
     * @param commitNoVerify a commitNoVerify object.
     */
    public void setCommitNoVerify( boolean commitNoVerify )
    {
        this.commitNoVerify = commitNoVerify;
    } //-- void setCommitNoVerify( boolean )

    /**
     * Set the actual name of the git executable.
     * 
     * @param gitCommand a gitCommand object.
     */
    public void setGitCommand( String gitCommand )
    {
        this.gitCommand = gitCommand;
    } //-- void setGitCommand( String )

    /**
     * Set the modelEncoding field.
     * 
     * @param modelEncoding a modelEncoding object.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set git format allowed by changelog command.
     * 
     * @param revParseDateFormat a revParseDateFormat object.
     */
    public void setRevParseDateFormat( String revParseDateFormat )
    {
        this.revParseDateFormat = revParseDateFormat;
    } //-- void setRevParseDateFormat( String )

    /**
     * Set traces the execution of a git command.
     *              could be 1,2, true or a file location.
     * 
     * @param traceGitCommand a traceGitCommand object.
     */
    public void setTraceGitCommand( String traceGitCommand )
    {
        this.traceGitCommand = traceGitCommand;
    } //-- void setTraceGitCommand( String )

}
