/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.metadata;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadata;
import org.apache.maven.scm.provider.local.metadata.io.xpp3.LocalScmMetadataXpp3Reader;
import org.apache.maven.scm.provider.local.metadata.io.xpp3.LocalScmMetadataXpp3Writer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalScmMetadataUtils {
    public static final String FILENAME = ".maven-scm-local";
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalScmMetadataUtils.class);

    public LocalScmMetadata buildMetadata(File repository) throws IOException {
        List repoFilenames = FileUtils.getFileNames((File)repository.getAbsoluteFile(), (String)"**", null, (boolean)false);
        LocalScmMetadata metadata = new LocalScmMetadata();
        metadata.setRepositoryFileNames(repoFilenames);
        return metadata;
    }

    public void writeMetadata(File destinationDir, LocalScmMetadata metadata) throws IOException {
        File metadataFile = new File(destinationDir, FILENAME);
        metadataFile.createNewFile();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)metadataFile);){
            new LocalScmMetadataXpp3Writer().write((Writer)writer, metadata);
        }
    }

    public LocalScmMetadata readMetadata(File dir) {
        LocalScmMetadata localScmMetadata;
        block12: {
            File metadataFile = new File(dir, FILENAME);
            if (!metadataFile.exists()) {
                return null;
            }
            XmlStreamReader reader = ReaderFactory.newXmlReader((File)metadataFile);
            try {
                LocalScmMetadata result;
                localScmMetadata = result = new LocalScmMetadataXpp3Reader().read((Reader)reader);
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Could not interpret .maven-scm-local - ignoring", (Throwable)e);
                    }
                    return null;
                }
                catch (IOException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Could not read .maven-scm-local - ignoring", (Throwable)e);
                    }
                    return null;
                }
            }
            reader.close();
        }
        return localScmMetadata;
    }
}

