/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.io.File;
import java.util.Date;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.changelog.PerforceChangeLogConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceChangeLogCommand
extends AbstractChangeLogCommand
implements PerforceCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        if (StringUtils.isNotEmpty((String)branch)) {
            throw new ScmException("This SCM doesn't support branches.");
        }
        Commandline cl = PerforceChangeLogCommand.createCommandLine((PerforceScmProviderRepository)repo, fileSet.getBasedir());
        PerforceChangeLogConsumer consumer = new PerforceChangeLogConsumer(startDate, endDate);
        return new ChangeLogScmResult(cl.toString(), consumer.getModifications());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory) {
        Commandline command = new Commandline();
        command.setExecutable("p4");
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        if (repo.getHost() != null) {
            command.createArgument().setValue("-H");
            String value = repo.getHost();
            if (repo.getPort() != 0) {
                value = value + ":" + Integer.toString(repo.getPort());
            }
            command.createArgument().setValue(value);
        }
        if (repo.getUser() != null) {
            command.createArgument().setValue("-u");
            command.createArgument().setValue(repo.getUser());
        }
        if (repo.getPassword() != null) {
            command.createArgument().setValue("-P");
            command.createArgument().setValue(repo.getPassword());
        }
        command.createArgument().setValue("filelog");
        command.createArgument().setValue("-t");
        command.createArgument().setValue("-l");
        command.createArgument().setValue(repo.getPath());
        return command;
    }
}

