/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam;

import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.add.StarteamAddCommand;
import org.apache.maven.scm.provider.starteam.command.changelog.StarteamChangeLogCommand;
import org.apache.maven.scm.provider.starteam.command.checkin.StarteamCheckInCommand;
import org.apache.maven.scm.provider.starteam.command.checkout.StarteamCheckOutCommand;
import org.apache.maven.scm.provider.starteam.command.diff.StarteamDiffCommand;
import org.apache.maven.scm.provider.starteam.command.status.StarteamStatusCommand;
import org.apache.maven.scm.provider.starteam.command.tag.StarteamTagCommand;
import org.apache.maven.scm.provider.starteam.command.update.StarteamUpdateCommand;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

public class StarteamScmProvider
extends AbstractScmProvider {
    public static final String STARTEAM_URL_FORMAT = "[username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]";

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        String path;
        int port;
        String host;
        String[] tokens;
        String user = null;
        String password = null;
        int index = scmSpecificUrl.indexOf(64);
        String rest = scmSpecificUrl;
        if (index != -1) {
            String userAndPassword = scmSpecificUrl.substring(0, index);
            rest = scmSpecificUrl.substring(index + 1);
            index = userAndPassword.indexOf(":");
            if (index != -1) {
                user = userAndPassword.substring(0, index);
                password = userAndPassword.substring(index + 1);
            } else {
                user = userAndPassword;
            }
        }
        if ((tokens = StringUtils.split((String)rest, (String)Character.toString(delimiter))).length == 3) {
            host = tokens[0];
            port = new Integer(tokens[1]);
            path = tokens[2];
        } else if (tokens.length == 2) {
            this.getLogger().warn("Your scm URL use a deprecated format. The new format is :[username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
            host = tokens[0];
            if (tokens[1].indexOf(47) == -1) {
                throw new ScmRepositoryException("Invalid SCM URL: The url has to be on the form: [username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
            }
            int at = tokens[1].indexOf(47);
            port = new Integer(tokens[1].substring(0, at));
            path = tokens[1].substring(at);
        } else {
            throw new ScmRepositoryException("Invalid SCM URL: The url has to be on the form: [username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
        }
        try {
            return new StarteamScmProviderRepository(user, password, host, port, path);
        }
        catch (Exception e) {
            throw new ScmRepositoryException("Invalid SCM URL: The url has to be on the form: [username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
        }
    }

    public String getScmType() {
        return "starteam";
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamAddCommand command = new StarteamAddCommand();
        command.setLogger(this.getLogger());
        return (AddScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public ChangeLogScmResult changelog(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamChangeLogCommand command = new StarteamChangeLogCommand();
        command.setLogger(this.getLogger());
        return (ChangeLogScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public CheckInScmResult checkin(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamCheckInCommand command = new StarteamCheckInCommand();
        command.setLogger(this.getLogger());
        return (CheckInScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public CheckOutScmResult checkout(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamCheckOutCommand command = new StarteamCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamDiffCommand command = new StarteamDiffCommand();
        command.setLogger(this.getLogger());
        return (DiffScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamStatusCommand command = new StarteamStatusCommand();
        command.setLogger(this.getLogger());
        return (StatusScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamTagCommand command = new StarteamTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        StarteamUpdateCommand command = new StarteamUpdateCommand();
        command.setLogger(this.getLogger());
        return (UpdateScmResult)command.execute(repository.getProviderRepository(), fileSet, parameters);
    }
}

