/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StarteamCommandLineUtils {
    public static Commandline createStarteamBaseCommandLine(String action, StarteamScmProviderRepository repo) {
        Commandline cl = new Commandline();
        cl.createArgument().setValue("stcmd");
        cl.createArgument().setValue(action);
        cl.createArgument().setValue("-x");
        cl.createArgument().setValue("-nologo");
        cl.createArgument().setValue("-stop");
        return cl;
    }

    public static Commandline createStarteamBaseCommandLine(String action, File relativeFileOrDir, StarteamScmProviderRepository repo) {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine(action, repo);
        String fullUrl = repo.getFullUrl();
        File relativeWorkingDir = relativeFileOrDir.getParentFile();
        if (relativeFileOrDir.isDirectory()) {
            relativeWorkingDir = relativeFileOrDir;
        } else if (relativeWorkingDir != null) {
            fullUrl = fullUrl + "/" + relativeWorkingDir.getPath().replace('\\', '/');
        }
        cl.createArgument().setValue("-p");
        cl.createArgument().setValue(fullUrl);
        File absoluteWorkingDir = relativeFileOrDir.getAbsoluteFile().getParentFile();
        if (relativeFileOrDir.isDirectory()) {
            absoluteWorkingDir = relativeFileOrDir.getAbsoluteFile();
        }
        cl.createArgument().setValue("-fp");
        cl.createArgument().setValue(absoluteWorkingDir.getAbsolutePath().replace('\\', '/'));
        return cl;
    }

    public static String toJavaPath(String path) {
        return path.replace('\\', '/');
    }

    public static String displayCommandlineWithoutPassword(Commandline cl) throws ScmException {
        String retStr = "";
        String fullStr = cl.toString();
        int usernamePos = fullStr.indexOf("-p ") + 3;
        if (usernamePos == 2) {
            throw new ScmException("Invalid command line");
        }
        retStr = fullStr.substring(0, usernamePos);
        int passwordStartPos = fullStr.indexOf(":");
        if (passwordStartPos == -1) {
            throw new ScmException("Invalid command line");
        }
        int passwordEndPos = fullStr.indexOf("@");
        if (passwordEndPos == -1) {
            throw new ScmException("Invalid command line");
        }
        retStr = retStr + fullStr.substring(usernamePos, passwordStartPos);
        retStr = retStr + fullStr.substring(passwordEndPos);
        return retStr;
    }

    public static int executeCommandline(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        logger.info("Command line: " + StarteamCommandLineUtils.displayCommandlineWithoutPassword(cl));
        try {
            return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
    }
}

