/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.update;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.changelog.StarteamChangeLogCommand;
import org.apache.maven.scm.provider.starteam.command.checkout.StarteamCheckOutConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamUpdateCommand
extends AbstractUpdateCommand
implements StarteamCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamCheckOutConsumer consumer = new StarteamCheckOutConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        File[] checkInFiles = fileSet.getFiles();
        if (checkInFiles.length == 0) {
            Commandline cl = StarteamUpdateCommand.createCommandLine(repository, fileSet.getBasedir(), tag);
            int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
            if (exitCode != 0) {
                return new UpdateScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        } else {
            for (int i = 0; i < checkInFiles.length; ++i) {
                Commandline cl = StarteamUpdateCommand.createCommandLine(repository, checkInFiles[i], tag);
                int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
                if (exitCode == 0) continue;
                return new UpdateScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        }
        return new UpdateScmResult(null, consumer.getCheckedOutFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File dirOrFile, String tag) {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("co", dirOrFile, repo);
        cl.createArgument().setValue("-merge");
        cl.createArgument().setValue("-neverprompt");
        if (tag != null && tag.length() != 0) {
            cl.createArgument().setValue("-vl");
            cl.createArgument().setValue(tag);
        }
        if (dirOrFile.isDirectory()) {
            cl.createArgument().setValue("-is");
        } else {
            cl.createArgument().setValue(dirOrFile.getName());
        }
        return cl;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        StarteamChangeLogCommand command = new StarteamChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

