/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.scm.providers.svn.settings.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.scm.providers.svn.settings.Settings;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class SvnXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class SvnXpp3Writer
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private static final String NAMESPACE = null;

    /**
     * Field fileComment.
     */
    private String fileComment = null;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method setFileComment.
     * 
     * @param fileComment a fileComment object.
     */
    public void setFileComment( String fileComment )
    {
        this.fileComment = fileComment;
    } //-- void setFileComment( String )

    /**
     * Method write.
     * 
     * @param writer a writer object.
     * @param settings a settings object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( Writer writer, Settings settings )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( settings.getModelEncoding(), null );
        writeSettings( settings, "svn-settings", serializer );
        serializer.endDocument();
    } //-- void write( Writer, Settings )

    /**
     * Method write.
     * 
     * @param stream a stream object.
     * @param settings a settings object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( OutputStream stream, Settings settings )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( stream, settings.getModelEncoding() );
        serializer.startDocument( settings.getModelEncoding(), null );
        writeSettings( settings, "svn-settings", serializer );
        serializer.endDocument();
    } //-- void write( OutputStream, Settings )

    /**
     * Method writeSettings.
     * 
     * @param settings a settings object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeSettings( Settings settings, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( this.fileComment != null )
        {
        serializer.comment(this.fileComment);
        }
        serializer.setPrefix( "", "http://maven.apache.org/SCM/SVN/2.1.2" );
        serializer.setPrefix( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        serializer.startTag( NAMESPACE, tagName );
        serializer.attribute( "", "xsi:schemaLocation", "http://maven.apache.org/SCM/SVN/2.1.2 https://maven.apache.org/xsd/svn-settings-2.1.2.xsd" );
        if ( settings.getConfigDirectory() != null )
        {
            serializer.startTag( NAMESPACE, "configDirectory" ).text( settings.getConfigDirectory() ).endTag( NAMESPACE, "configDirectory" );
        }
        if ( settings.isUseCygwinPath() != false )
        {
            serializer.startTag( NAMESPACE, "useCygwinPath" ).text( String.valueOf( settings.isUseCygwinPath() ) ).endTag( NAMESPACE, "useCygwinPath" );
        }
        if ( ( settings.getCygwinMountPath() != null ) && !settings.getCygwinMountPath().equals( "/cygwin" ) )
        {
            serializer.startTag( NAMESPACE, "cygwinMountPath" ).text( settings.getCygwinMountPath() ).endTag( NAMESPACE, "cygwinMountPath" );
        }
        if ( settings.isUseNonInteractive() != false )
        {
            serializer.startTag( NAMESPACE, "useNonInteractive" ).text( String.valueOf( settings.isUseNonInteractive() ) ).endTag( NAMESPACE, "useNonInteractive" );
        }
        if ( settings.isUseAuthCache() != false )
        {
            serializer.startTag( NAMESPACE, "useAuthCache" ).text( String.valueOf( settings.isUseAuthCache() ) ).endTag( NAMESPACE, "useAuthCache" );
        }
        if ( settings.isTrustServerCert() != false )
        {
            serializer.startTag( NAMESPACE, "trustServerCert" ).text( String.valueOf( settings.isTrustServerCert() ) ).endTag( NAMESPACE, "trustServerCert" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeSettings( Settings, String, XmlSerializer )

}
