/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.changelog;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.command.changelog.SvnChangeLogConsumer;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnChangeLogCommand
extends AbstractChangeLogCommand
implements SvnCommand {
    private static final String DATE_FORMAT = "yyyy/MM/dd 'GMT'";

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        int exitCode;
        Commandline cl = SvnChangeLogCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), branch, startDate, endDate);
        SvnChangeLogConsumer consumer = new SvnChangeLogConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing svn command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new ChangeLogScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new ChangeLogScmResult(cl.toString(), consumer.getModifications());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String branch, Date startDate, Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArgument().setValue("log");
        cl.createArgument().setValue("-v");
        if (startDate != null) {
            cl.createArgument().setValue("-r");
            if (endDate != null) {
                cl.createArgument().setValue("{" + dateFormat.format(startDate) + "}" + ":" + "{" + dateFormat.format(endDate) + "}");
            } else {
                cl.createArgument().setValue("{" + dateFormat.format(startDate) + "}:HEAD");
            }
        } else if (branch != null) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(branch);
        }
        cl.createArgument().setValue(repository.getUrl());
        return cl;
    }
}

