/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.diff;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.command.diff.SvnDiffConsumer;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnDiffCommand
extends AbstractDiffCommand
implements SvnCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, String startRevision, String endRevision) throws ScmException {
        int exitCode;
        Commandline cl = SvnDiffCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), startRevision, endRevision);
        SvnDiffConsumer consumer = new SvnDiffConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new DiffScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new DiffScmResult(cl.toString(), consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String startRevision, String endRevision) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArgument().setValue("diff");
        if (startRevision != null) {
            cl.createArgument().setValue("-r");
            if (endRevision != null) {
                cl.createArgument().setValue(startRevision + ":" + endRevision);
            } else {
                cl.createArgument().setValue(startRevision);
            }
        }
        return cl;
    }
}

