/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.update;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.command.changelog.SvnChangeLogCommand;
import org.apache.maven.scm.provider.svn.command.update.SvnUpdateConsumer;
import org.apache.maven.scm.provider.svn.command.update.SvnUpdateScmResult;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnUpdateCommand
extends AbstractUpdateCommand
implements SvnCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        Commandline cl = SvnUpdateCommand.createCommandLine((SvnScmProviderRepository)repo, fileSet.getBasedir(), tag);
        SvnUpdateConsumer consumer = new SvnUpdateConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new UpdateScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new SvnUpdateScmResult(cl.toString(), consumer.getUpdatedFiles(), consumer.getRevision());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String tag) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory, repository);
        cl.createArgument().setValue("update");
        if (tag != null) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(tag);
        }
        return cl;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        SvnChangeLogCommand command = new SvnChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

