/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.command.update;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnUpdateConsumer
implements StreamConsumer {
    private static final String UPDATED_TO_REVISION_TOKEN = "Updated to revision";
    private static final String AT_REVISION_TOKEN = "At revision";
    private ScmLogger logger;
    private File workingDirectory;
    private List updatedFiles = new ArrayList();
    private int revision;

    public SvnUpdateConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    public void consumeLine(String line) {
        ScmFileStatus status;
        this.logger.debug(line);
        if (line.length() <= 3) {
            this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(3).trim();
        if (line.startsWith(UPDATED_TO_REVISION_TOKEN)) {
            String revisionString = line.substring(UPDATED_TO_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (line.startsWith(AT_REVISION_TOKEN)) {
            String revisionString = line.substring(AT_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("U")) {
            status = ScmFileStatus.UPDATED;
        } else if (statusString.equals("D")) {
            status = ScmFileStatus.DELETED;
        } else {
            this.logger.info("Unknown file status: '" + statusString + "'.");
            return;
        }
        if (!new File(this.workingDirectory, file).isFile()) {
            this.logger.debug("Skipping non-file: " + file);
            return;
        }
        this.updatedFiles.add(new ScmFile(file, status));
    }

    public List getUpdatedFiles() {
        return this.updatedFiles;
    }

    public int getRevision() {
        return this.revision;
    }

    private int parseInt(String revisionString) {
        try {
            return Integer.parseInt(revisionString);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }
}

