/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.remove;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.util.AbstractConsumer;

public class SvnRemoveConsumer
extends AbstractConsumer {
    private final List<ScmFile> removedFiles = new ArrayList<ScmFile>();

    public void consumeLine(String line) {
        if (line.length() <= 3) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            }
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(3).trim();
        if (!statusString.equals("D")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Unknown file status: '" + statusString + "'.");
            }
            return;
        }
        ScmFileStatus status = ScmFileStatus.DELETED;
        this.removedFiles.add(new ScmFile(file, status));
    }

    public List<ScmFile> getRemovedFiles() {
        return this.removedFiles;
    }
}

