/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency;

import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.DefaultDependencyCoordinate;
import org.apache.maven.shared.dependency.DependencyCoordinate;

public final class TransferUtils {
    private TransferUtils() {
    }

    public static DependencyCoordinate toDependencyCoordinate(Dependency dependency) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(dependency.getGroupId());
        coordinate.setArtifactId(dependency.getArtifactId());
        coordinate.setVersion(dependency.getVersion());
        coordinate.setType(dependency.getType());
        coordinate.setClassifier(dependency.getClassifier());
        return coordinate;
    }

    public static DependencyCoordinate toDependencyCoordinate(Extension extension) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(extension.getGroupId());
        coordinate.setArtifactId(extension.getArtifactId());
        coordinate.setVersion(extension.getVersion());
        return coordinate;
    }

    public static DependencyCoordinate toDependencyCoordinate(MavenProject project) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(project.getGroupId());
        coordinate.setArtifactId(project.getArtifactId());
        coordinate.setVersion(project.getVersion());
        coordinate.setType(project.getPackaging());
        return coordinate;
    }

    public static DependencyCoordinate toDependencyCoordinate(Model model) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(model.getGroupId());
        coordinate.setArtifactId(model.getArtifactId());
        coordinate.setVersion(model.getVersion());
        coordinate.setType(model.getPackaging());
        return coordinate;
    }

    public static DependencyCoordinate toDependencyCoordinate(Parent parent) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(parent.getGroupId());
        coordinate.setArtifactId(parent.getArtifactId());
        coordinate.setVersion(parent.getVersion());
        coordinate.setType("pom");
        return coordinate;
    }

    public static DependencyCoordinate toDependencyCoordinate(Plugin plugin) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(plugin.getGroupId());
        coordinate.setArtifactId(plugin.getArtifactId());
        coordinate.setVersion(plugin.getVersion());
        return coordinate;
    }

    public static DependencyCoordinate toDependencyCoordinate(ReportPlugin plugin) {
        DefaultDependencyCoordinate coordinate = new DefaultDependencyCoordinate();
        coordinate.setGroupId(plugin.getGroupId());
        coordinate.setArtifactId(plugin.getArtifactId());
        coordinate.setVersion(plugin.getVersion());
        return coordinate;
    }
}

