/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.collect.internal;

import java.util.Collection;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.collect.CollectorResult;
import org.apache.maven.shared.dependency.collect.DependencyCollector;
import org.apache.maven.shared.dependency.collect.DependencyCollectorException;
import org.apache.maven.shared.dependency.collect.internal.Invoker;
import org.apache.maven.shared.dependency.collect.internal.Maven31CollectorResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;

@Component(role=DependencyCollector.class, hint="maven31")
public class Maven31DependencyCollector
implements DependencyCollector {
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Dependency root) throws DependencyCollectorException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Class[] argClasses = new Class[]{Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{root, typeRegistry};
        org.eclipse.aether.graph.Dependency aetherRoot = (org.eclipse.aether.graph.Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
        return this.collectDependencies(buildingRequest, aetherRoot);
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Artifact root) throws DependencyCollectorException {
        Class[] argClasses = new Class[]{Artifact.class, Collection.class};
        Object[] args = new Object[]{root, null};
        org.eclipse.aether.graph.Dependency aetherRoot = (org.eclipse.aether.graph.Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
        return this.collectDependencies(buildingRequest, aetherRoot);
    }

    private CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, org.eclipse.aether.graph.Dependency aetherRoot) throws DependencyCollectorException {
        CollectRequest request = new CollectRequest();
        request.setRoot(aetherRoot);
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, (Object)buildingRequest.getRemoteRepositories());
        request.setRepositories(aetherRepositories);
        try {
            return new Maven31CollectorResult(this.repositorySystem.collectDependencies(session, request));
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }
}

