/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer.asm;

import org.apache.maven.shared.dependency.analyzer.asm.ResultCollector;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class DefaultClassVisitor
extends ClassVisitor {
    private final ResultCollector resultCollector;
    private final SignatureVisitor signatureVisitor;
    private final AnnotationVisitor annotationVisitor;
    private final FieldVisitor fieldVisitor;
    private final MethodVisitor methodVisitor;

    public DefaultClassVisitor(SignatureVisitor signatureVisitor, AnnotationVisitor annotationVisitor, FieldVisitor fieldVisitor, MethodVisitor methodVisitor, ResultCollector resultCollector) {
        super(589824);
        this.signatureVisitor = signatureVisitor;
        this.annotationVisitor = annotationVisitor;
        this.fieldVisitor = fieldVisitor;
        this.methodVisitor = methodVisitor;
        this.resultCollector = resultCollector;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (signature == null) {
            this.resultCollector.addName(superName);
            this.resultCollector.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.resultCollector.addDesc(desc);
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.resultCollector.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.resultCollector.addType((Type)value);
        }
        return this.fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature == null) {
            this.resultCollector.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.resultCollector.addNames(exceptions);
        return this.methodVisitor;
    }

    public void visitNestHost(String nestHost) {
        this.resultCollector.addName(nestHost);
    }

    public void visitNestMember(String nestMember) {
        this.resultCollector.addName(nestMember);
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept(this.signatureVisitor);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType(this.signatureVisitor);
        }
    }
}

