/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jarsigner;

import javax.inject.Named;
import org.apache.maven.shared.jarsigner.CommandLineConfigurationException;
import org.apache.maven.shared.jarsigner.JarSigner;
import org.apache.maven.shared.jarsigner.JarSignerCommandLineBuilder;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.javatool.AbstractJavaTool;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;

@Named
public class DefaultJarSigner
extends AbstractJavaTool<JarSignerRequest>
implements JarSigner {
    public DefaultJarSigner() {
        super("jarsigner");
    }

    protected Commandline createCommandLine(JarSignerRequest request, String javaToolFile) throws JavaToolException {
        JarSignerCommandLineBuilder cliBuilder = new JarSignerCommandLineBuilder();
        cliBuilder.setJarSignerFile(javaToolFile);
        try {
            Commandline cli = cliBuilder.build(request);
            if (request.isVerbose()) {
                this.getLogger().info(cli.toString());
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(cli.toString());
            }
            return cli;
        }
        catch (CommandLineConfigurationException e) {
            throw new JavaToolException("Error configuring command-line. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    protected StreamConsumer createSystemOutStreamConsumer(JarSignerRequest request) {
        StreamConsumer systemOut = request.getSystemOutStreamConsumer();
        if (systemOut == null) {
            boolean verbose = request.isVerbose();
            systemOut = line -> {
                if (verbose) {
                    this.getLogger().info(line);
                } else {
                    this.getLogger().debug(line);
                }
            };
        }
        return systemOut;
    }
}

