/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit48;

import org.apache.maven.surefire.testset.ResolvedTest;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class RequestedTest
extends Filter {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final ResolvedTest test;
    private final boolean isPositiveFilter;

    RequestedTest(ResolvedTest test, boolean isPositiveFilter) {
        this.test = test;
        this.isPositiveFilter = isPositiveFilter;
    }

    public boolean shouldRun(Description description) {
        Class realTestClass = description.getTestClass();
        String methodName = description.getMethodName();
        if (realTestClass == null && methodName == null) {
            return true;
        }
        String testClass = this.classFile(realTestClass);
        return this.isPositiveFilter ? this.test.matchAsInclusive(testClass, methodName) : !this.test.matchAsExclusive(testClass, methodName);
    }

    public String describe() {
        String description = this.test.toString();
        return description.isEmpty() ? "*" : description;
    }

    public boolean equals(Object o) {
        return this == o || o != null && ((Object)((Object)this)).getClass() == o.getClass() && this.equals((RequestedTest)((Object)o));
    }

    private boolean equals(RequestedTest o) {
        return this.isPositiveFilter == o.isPositiveFilter && this.test.equals((Object)o.test);
    }

    public int hashCode() {
        return this.test.hashCode();
    }

    private String classFile(Class<?> realTestClass) {
        return realTestClass == null ? null : realTestClass.getName().replace('.', '/') + CLASS_FILE_EXTENSION;
    }
}

