/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.List;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.Level;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.logging.MessageUtils;

public class ConsoleReporter {
    public static final String BRIEF = "brief";
    public static final String PLAIN = "plain";
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private final ConsoleLogger logger;

    public ConsoleReporter(ConsoleLogger logger) {
        this.logger = logger;
    }

    public ConsoleLogger getConsoleLogger() {
        return this.logger;
    }

    public void testSetStarting(ReportEntry report) {
        MessageBuilder builder = MessageUtils.buffer();
        this.logger.info(TestSetStats.concatenateWithTestGroup(builder.a(TEST_SET_STARTING_PREFIX), report));
    }

    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        boolean success = testSetStats.getCompletedCount() > 0;
        boolean failures = testSetStats.getFailures() > 0;
        boolean errors = testSetStats.getErrors() > 0;
        boolean skipped = testSetStats.getSkipped() > 0;
        boolean flakes = testSetStats.getSkipped() > 0;
        Level level = Level.resolveLevel((boolean)success, (boolean)failures, (boolean)errors, (boolean)skipped, (boolean)flakes);
        this.println(testSetStats.getColoredTestSetSummary(report), level);
        for (String testResult : testResults) {
            this.println(testResult, level);
        }
    }

    public void reset() {
    }

    private void println(String message, Level level) {
        switch (level) {
            case FAILURE: {
                this.logger.error(message);
                break;
            }
            case UNSTABLE: {
                this.logger.warning(message);
                break;
            }
            default: {
                this.logger.info(message);
            }
        }
    }
}

